/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;
import org.camunda.bpm.engine.impl.tree.ScopeCollector;

public class ProcessInstanceStartContext
extends ExecutionStartContext {
    protected ActivityImpl initial;
    protected InstantiationStack instantiationStack;

    public ProcessInstanceStartContext(ActivityImpl initial) {
        this.initial = initial;
    }

    public ActivityImpl getInitial() {
        return this.initial;
    }

    public void setInitial(ActivityImpl initial) {
        this.initial = initial;
    }

    @Override
    public InstantiationStack getInstantiationStack() {
        if (this.instantiationStack == null) {
            FlowScopeWalker flowScopeWalker = new FlowScopeWalker(this.initial.getFlowScope());
            ScopeCollector scopeCollector = new ScopeCollector();
            flowScopeWalker.addPreVisitor(scopeCollector).walkWhile(new ReferenceWalker.WalkCondition<ScopeImpl>(){

                @Override
                public boolean isFulfilled(ScopeImpl element) {
                    return element == null || element == ProcessInstanceStartContext.this.initial.getProcessDefinition();
                }
            });
            List<ScopeImpl> scopeActivities = scopeCollector.getScopes();
            Collections.reverse(scopeActivities);
            this.instantiationStack = new InstantiationStack(scopeActivities, this.initial, null);
        }
        return this.instantiationStack;
    }

    public boolean isAsync() {
        return this.initial.isAsyncBefore();
    }
}

