/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import org.camunda.bpm.engine.SchemaOperationsCommand;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;

public final class SchemaOperationsProcessEngineBuild
implements SchemaOperationsCommand {
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    @Override
    public Void execute(CommandContext commandContext) {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        PersistenceSession persistenceSession = commandContext.getSession(PersistenceSession.class);
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                persistenceSession.dbSchemaDrop();
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            persistenceSession.dbSchemaUpdate();
        }
        this.checkDeploymentLockExists(commandContext);
        this.checkHistoryCleanupLockExists(commandContext);
        if (Context.getProcessEngineConfiguration().getManagementService().getTableMetaData("ACT_RU_JOB") != null) {
            Context.getProcessEngineConfiguration().getHistoryService().cleanUpHistoryAsync();
        }
        return null;
    }

    public void checkDeploymentLockExists(CommandContext commandContext) {
        PropertyEntity deploymentLockProperty = commandContext.getPropertyManager().findPropertyById("deployment.lock");
        if (deploymentLockProperty == null) {
            LOG.noDeploymentLockPropertyFound();
        }
    }

    public void checkHistoryCleanupLockExists(CommandContext commandContext) {
        PropertyEntity historyCleanupLockProperty = commandContext.getPropertyManager().findPropertyById("history.cleanup.job.lock");
        if (historyCleanupLockProperty == null) {
            LOG.noHistoryCleanupLockPropertyFound();
        }
    }
}

