/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn;

import java.util.Map;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmmn.cmd.CreateCaseInstanceCmd;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnOperationLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceBuilder;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class CaseInstanceBuilderImpl
implements CaseInstanceBuilder {
    private static final CmmnOperationLogger LOG = ProcessEngineLogger.CMMN_OPERATION_LOGGER;
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String businessKey;
    protected VariableMap variables;
    protected String caseDefinitionTenantId;
    protected boolean isTenantIdSet = false;

    public CaseInstanceBuilderImpl(CommandExecutor commandExecutor, String caseDefinitionKey, String caseDefinitionId) {
        this(caseDefinitionKey, caseDefinitionId);
        EnsureUtil.ensureNotNull("commandExecutor", (Object)commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public CaseInstanceBuilderImpl(CommandContext commandContext, String caseDefinitionKey, String caseDefinitionId) {
        this(caseDefinitionKey, caseDefinitionId);
        EnsureUtil.ensureNotNull("commandContext", (Object)commandContext);
        this.commandContext = commandContext;
    }

    private CaseInstanceBuilderImpl(String caseDefinitionKey, String caseDefinitionId) {
        this.caseDefinitionKey = caseDefinitionKey;
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public CaseInstanceBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public CaseInstanceBuilder caseDefinitionTenantId(String tenantId) {
        this.caseDefinitionTenantId = tenantId;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public CaseInstanceBuilder caseDefinitionWithoutTenantId() {
        this.caseDefinitionTenantId = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public CaseInstanceBuilder setVariable(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull(NotValidException.class, "variableName", (Object)variableName);
        if (this.variables == null) {
            this.variables = Variables.createVariables();
        }
        this.variables.putValue(variableName, variableValue);
        return this;
    }

    @Override
    public CaseInstanceBuilder setVariables(Map<String, Object> variables) {
        if (variables != null) {
            if (this.variables == null) {
                this.variables = Variables.fromMap(variables);
            } else {
                this.variables.putAll(variables);
            }
        }
        return this;
    }

    @Override
    public CaseInstance create() {
        if (this.isTenantIdSet && this.caseDefinitionId != null) {
            throw LOG.exceptionCreateCaseInstanceByIdAndTenantId();
        }
        try {
            CreateCaseInstanceCmd command = new CreateCaseInstanceCmd(this);
            if (this.commandExecutor != null) {
                return this.commandExecutor.execute(command);
            }
            return command.execute(this.commandContext);
        }
        catch (CaseDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CaseIllegalStateTransitionException e) {
            throw new NotAllowedException(e.getMessage(), e);
        }
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public String getCaseDefinitionTenantId() {
        return this.caseDefinitionTenantId;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }
}

