/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationActivityEnd
implements PvmAtomicOperation {
    protected PvmScope getScope(PvmExecutionImpl execution) {
        return execution.getActivity();
    }

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return execution.getActivity().isAsyncAfter();
    }

    @Override
    public boolean isAsyncCapable() {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        if (execution.getActivityInstanceId() == null) {
            execution.setActivityInstanceId(execution.getParentActivityInstanceId());
        }
        ActivityImpl activity = execution.getActivity();
        Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = execution.createActivityExecutionMapping();
        PvmExecutionImpl propagatingExecution = execution;
        if (execution.isScope() && activity.isScope() && !LegacyBehavior.destroySecondNonScope(execution)) {
            execution.destroy();
            if (!execution.isConcurrent()) {
                execution.remove();
                propagatingExecution = execution.getParent();
                propagatingExecution.setActivity(execution.getActivity());
            }
        }
        propagatingExecution = LegacyBehavior.determinePropagatingExecutionOnEnd(propagatingExecution, activityExecutionMapping);
        ScopeImpl flowScope = activity.getFlowScope();
        if (flowScope == activity.getProcessDefinition()) {
            if (propagatingExecution.isConcurrent()) {
                propagatingExecution.remove();
                propagatingExecution.getParent().tryPruneLastConcurrentChild();
                propagatingExecution.getParent().forceUpdate();
            } else if (!propagatingExecution.isPreserveScope()) {
                propagatingExecution.performOperation(PROCESS_END);
            }
        } else {
            PvmActivity flowScopeActivity = (PvmActivity)((Object)flowScope);
            ActivityBehavior activityBehavior = flowScopeActivity.getActivityBehavior();
            if (activityBehavior instanceof CompositeActivityBehavior) {
                CompositeActivityBehavior compositeActivityBehavior = (CompositeActivityBehavior)activityBehavior;
                if (propagatingExecution.isConcurrent() && !LegacyBehavior.isConcurrentScope(propagatingExecution)) {
                    compositeActivityBehavior.concurrentChildExecutionEnded(propagatingExecution.getParent(), propagatingExecution);
                } else {
                    propagatingExecution.setActivity(flowScopeActivity);
                    compositeActivityBehavior.complete(propagatingExecution);
                }
            } else {
                throw new ProcessEngineException("Expected behavior of composite scope " + activity + " to be a CompositeActivityBehavior but got " + activityBehavior);
            }
        }
    }

    @Override
    public String getCanonicalName() {
        return "activity-end";
    }
}

