/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import org.camunda.bpm.engine.ClassLoadingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.util.io.StreamSource;

public class EngineUtilLogger
extends ProcessEngineLogger {
    public ProcessEngineException malformedUrlException(String url, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("001", "The URL '{}' is malformed", new Object[]{url}), cause);
    }

    public ProcessEngineException multipleSourcesException(StreamSource source1, StreamSource source2) {
        return new ProcessEngineException(this.exceptionMessage("002", "Multiple sources detected, which is invalid. Source 1: '{}', Source 2: {}", new Object[]{source1, source2}));
    }

    public ProcessEngineException parsingFailureException(String name, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("003", "Could not parse '{}'.", new Object[]{name}), cause);
    }

    public void logParseWarnings(String formattedMessage) {
        this.logWarn("004", "Warnings during parsing: {}", new Object[]{formattedMessage});
    }

    public ProcessEngineException exceptionDuringParsing(String string) {
        return new ProcessEngineException(this.exceptionMessage("005", "Could not parse BPMN process. Errors: {}", new Object[]{string}));
    }

    public void unableToSetSchemaResource(Throwable cause) {
        this.logWarn("006", "Setting schema resource failed because of: '{}'", new Object[]{cause.getMessage(), cause});
    }

    public ProcessEngineException invalidBitNumber(int bitNumber) {
        return new ProcessEngineException(this.exceptionMessage("007", "Invalid bit {}. Only 8 bits are supported.", new Object[]{bitNumber}));
    }

    public ProcessEngineException exceptionWhileInstantiatingClass(String className, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("008", "Exception while instantiating class '{}': {}", new Object[]{className, e.getMessage()}), e);
    }

    public ProcessEngineException exceptionWhileApplyingFieldDeclatation(String declName, String className, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("009", "Exception while applying field declaration '{}' on class '{}': {}", new Object[]{declName, className, e.getMessage()}), e);
    }

    public ProcessEngineException incompatibleTypeForFieldDeclaration(FieldDeclaration declaration, Object target, Field field) {
        return new ProcessEngineException(this.exceptionMessage("010", "Incompatible type set on field declaration '{}' for class '{}'. Declared value has type '{}', while expecting '{}'", new Object[]{declaration.getName(), target.getClass().getName(), declaration.getValue().getClass().getName(), field.getType().getName()}));
    }

    public ProcessEngineException exceptionWhileReadingStream(String inputStreamName, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("011", "Exception while reading {} as input stream: {}", new Object[]{inputStreamName, e.getMessage()}), e);
    }

    public ProcessEngineException exceptionWhileReadingFile(String filePath, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("012", "Exception while reading file {}: {}", new Object[]{filePath, e.getMessage()}), e);
    }

    public ProcessEngineException exceptionWhileGettingFile(String filePath, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("013", "Exception while getting file {}: {}", new Object[]{filePath, e.getMessage()}), e);
    }

    public ProcessEngineException exceptionWhileWritingToFile(String filePath, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("014", "Exception while writing to file {}: {}", new Object[]{filePath, e.getMessage()}), e);
    }

    public void debugCloseException(IOException ignore) {
        this.logDebug("015", "Ignored exception on resource close", new Object[]{ignore});
    }

    public void debugClassLoading(String className, String classLoaderDescription, ClassLoader classLoader) {
        this.logDebug("016", "Attempting to load class '{}' with {}: {}", new Object[]{className, classLoaderDescription, classLoader});
    }

    public ClassLoadingException classLoadingException(String className, Throwable throwable) {
        return new ClassLoadingException(this.exceptionMessage("017", "Cannot load class '{}': {}", new Object[]{className, throwable.getMessage()}), className, throwable);
    }

    public ProcessEngineException cannotConvertUrlToUri(URL url, URISyntaxException e) {
        return new ProcessEngineException(this.exceptionMessage("018", "Cannot convert URL[{}] to URI: {}", new Object[]{url, e.getMessage()}), e);
    }

    public ProcessEngineException exceptionWhileInvokingMethod(String methodName, Object target, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("019", "Exception while invoking method '{}' on object of type '{}': {}'", new Object[]{methodName, target, e.getMessage()}), e);
    }

    public ProcessEngineException unableToAccessField(Field field, String name) {
        return new ProcessEngineException(this.exceptionMessage("020", "Unable to access field {} on class {}, access protected", new Object[]{field, name}));
    }

    public ProcessEngineException unableToAccessMethod(String methodName, String name) {
        return new ProcessEngineException(this.exceptionMessage("021", "Unable to access method {} on class {}, access protected", new Object[]{methodName, name}));
    }

    public ProcessEngineException exceptionWhileSettingField(Field field, Object object, Object value, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("022", "Exception while setting value '{}' to field '{}' on object of type '{}': {}", new Object[]{value, field, object.getClass().getName(), e.getMessage()}), e);
    }

    public ProcessEngineException ambiguousSetterMethod(String setterName, String name) {
        return new ProcessEngineException(this.exceptionMessage("023", "Ambiguous setter: more than one method named {} on class {}, with different parameter types.", new Object[]{setterName, name}));
    }

    public NotFoundException cannotFindResource(String resourcePath) {
        return new NotFoundException(this.exceptionMessage("024", "Unable to find resource at path {}", new Object[]{resourcePath}));
    }

    public IllegalStateException notInsideCommandContext(String operation) {
        return new IllegalStateException(this.exceptionMessage("025", "Operation {} requires active command context. No command context active on thread {}.", new Object[]{operation, Thread.currentThread()}));
    }

    public ProcessEngineException exceptionWhileParsingCronExpresison(String duedateDescription, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("026", "Exception while parsing cron expression '{}': {}", new Object[]{duedateDescription, e.getMessage()}), e);
    }

    public ProcessEngineException exceptionWhileResolvingDuedate(String duedate, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("027", "Exception while resolving duedate '{}': {}", new Object[]{duedate, e.getMessage()}), e);
    }

    public Exception cannotParseDuration(String expressions) {
        return new ProcessEngineException(this.exceptionMessage("028", "Cannot parse duration '{}'.", new Object[]{expressions}));
    }

    public void logParsingRetryIntervals(String intervals, Exception e) {
        this.logWarn("029", "Exception while parsing retry intervals '{}'", new Object[]{intervals, e.getMessage(), e});
    }
}

