/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class FoxDeleteProcessInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String deleteReason;

    public FoxDeleteProcessInstanceCmd(String processInstanceId, String deleteReason) {
        this.processInstanceId = processInstanceId;
        this.deleteReason = deleteReason;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)this.processInstanceId);
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        EnsureUtil.ensureNotNull("No process instance found for id '" + this.processInstanceId + "'", "execution", (Object)execution);
        commandContext.getTaskManager().deleteTasksByProcessInstanceId(this.processInstanceId, this.deleteReason, false, false);
        for (PvmExecutionImpl currentExecution : this.collectExecutionToDelete(execution)) {
            currentExecution.deleteCascade2(this.deleteReason);
        }
        return null;
    }

    public List<PvmExecutionImpl> collectExecutionToDelete(PvmExecutionImpl execution) {
        ArrayList<PvmExecutionImpl> result = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : execution.getExecutions()) {
            result.addAll(this.collectExecutionToDelete(pvmExecutionImpl));
        }
        if (execution.getSubProcessInstance() != null) {
            result.addAll(this.collectExecutionToDelete(execution.getSubProcessInstance()));
        }
        result.add(execution);
        return result;
    }
}

