/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.externaltask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.cmd.FetchExternalTasksCmd;
import org.camunda.bpm.engine.impl.externaltask.TopicFetchInstruction;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;

public class ExternalTaskQueryTopicBuilderImpl
implements ExternalTaskQueryTopicBuilder {
    protected CommandExecutor commandExecutor;
    protected String workerId;
    protected int maxTasks;
    protected boolean usePriority;
    protected Map<String, TopicFetchInstruction> instructions;
    protected boolean filterByBusinessKey;
    protected TopicFetchInstruction currentInstruction;

    public ExternalTaskQueryTopicBuilderImpl(CommandExecutor commandExecutor, String workerId, int maxTasks, boolean usePriority) {
        this.commandExecutor = commandExecutor;
        this.workerId = workerId;
        this.maxTasks = maxTasks;
        this.usePriority = usePriority;
        this.filterByBusinessKey = false;
        this.instructions = new HashMap<String, TopicFetchInstruction>();
    }

    @Override
    public List<LockedExternalTask> execute() {
        this.submitCurrentInstruction();
        return this.commandExecutor.execute(new FetchExternalTasksCmd(this.workerId, this.maxTasks, this.instructions, this.filterByBusinessKey, this.usePriority));
    }

    @Override
    public ExternalTaskQueryTopicBuilder topic(String topicName, long lockDuration) {
        this.submitCurrentInstruction();
        this.currentInstruction = new TopicFetchInstruction(topicName, lockDuration);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder variables(String ... variables) {
        if (variables != null) {
            this.currentInstruction.setVariablesToFetch(new ArrayList<String>(Arrays.asList(variables)));
        }
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder variables(List<String> variables) {
        this.currentInstruction.setVariablesToFetch(variables);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processInstanceVariableEquals(Map<String, Object> variables) {
        this.currentInstruction.setFilterVariables(variables);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder processInstanceVariableEquals(String name, Object value) {
        this.currentInstruction.addFilterVariable(name, value);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder businessKey(String businessKey) {
        this.filterByBusinessKey = true;
        this.currentInstruction.setBusinessKey(businessKey);
        return this;
    }

    protected void submitCurrentInstruction() {
        if (this.currentInstruction != null) {
            this.instructions.put(this.currentInstruction.getTopicName(), this.currentInstruction);
        }
    }

    @Override
    public ExternalTaskQueryTopicBuilder enableCustomObjectDeserialization() {
        this.currentInstruction.setDeserializeVariables(true);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder localVariables() {
        this.currentInstruction.setLocalVariables(true);
        return this;
    }
}

