/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.cmd.DeleteProcessDefinitionsByIdsCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteProcessDefinitionsByKeyCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsBuilder;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsSelectBuilder;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsTenantBuilder;

public class DeleteProcessDefinitionsBuilderImpl
implements DeleteProcessDefinitionsBuilder,
DeleteProcessDefinitionsSelectBuilder,
DeleteProcessDefinitionsTenantBuilder {
    private final CommandExecutor commandExecutor;
    private String processDefinitionKey;
    private List<String> processDefinitionIds;
    private boolean cascade;
    private String tenantId;
    private boolean isTenantIdSet;
    private boolean skipCustomListeners;

    public DeleteProcessDefinitionsBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public DeleteProcessDefinitionsBuilderImpl byIds(String ... processDefinitionId) {
        if (processDefinitionId != null) {
            this.processDefinitionIds = new ArrayList<String>();
            this.processDefinitionIds.addAll(Arrays.asList(processDefinitionId));
        }
        return this;
    }

    @Override
    public DeleteProcessDefinitionsBuilderImpl byKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public DeleteProcessDefinitionsBuilderImpl withoutTenantId() {
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public DeleteProcessDefinitionsBuilderImpl withTenantId(String tenantId) {
        EnsureUtil.ensureNotNull("tenantId", (Object)tenantId);
        this.isTenantIdSet = true;
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public DeleteProcessDefinitionsBuilderImpl cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public DeleteProcessDefinitionsBuilderImpl skipCustomListeners() {
        this.skipCustomListeners = true;
        return this;
    }

    @Override
    public void delete() {
        Command<Void> command;
        EnsureUtil.ensureOnlyOneNotNull(NullValueException.class, "'processDefinitionKey' or 'processDefinitionIds' cannot be null", this.processDefinitionKey, this.processDefinitionIds);
        if (this.processDefinitionKey != null) {
            command = new DeleteProcessDefinitionsByKeyCmd(this.processDefinitionKey, this.cascade, this.skipCustomListeners, this.tenantId, this.isTenantIdSet);
        } else if (this.processDefinitionIds != null && !this.processDefinitionIds.isEmpty()) {
            command = new DeleteProcessDefinitionsByIdsCmd(this.processDefinitionIds, this.cascade, this.skipCustomListeners);
        } else {
            return;
        }
        this.commandExecutor.execute(command);
    }
}

