/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.interceptor.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.camunda.bpm.client.impl.EngineClientLogger;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.interceptor.ClientRequestInterceptor;
import org.camunda.bpm.client.interceptor.impl.ClientRequestContextImpl;

public class RequestInterceptorHandler
implements HttpRequestInterceptor {
    protected static final EngineClientLogger LOG = ExternalTaskClientLogger.ENGINE_CLIENT_LOGGER;
    protected List<ClientRequestInterceptor> interceptors;

    public RequestInterceptorHandler(List<ClientRequestInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void process(HttpRequest httpRequest, EntityDetails details, HttpContext context) throws HttpException, IOException {
        ClientRequestContextImpl interceptedRequest = new ClientRequestContextImpl();
        this.interceptors.forEach(requestInterceptor -> {
            try {
                requestInterceptor.intercept(interceptedRequest);
            }
            catch (Throwable e) {
                LOG.requestInterceptorException(e);
            }
        });
        Map<String, String> newHeaders = interceptedRequest.getHeaders();
        newHeaders.forEach((headerName, headerValue) -> httpRequest.addHeader((Header)new BasicHeader(headerName, headerValue)));
    }

    public List<ClientRequestInterceptor> getInterceptors() {
        return this.interceptors;
    }
}

