/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.type;

import org.camunda.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class IntegerDataTypeTransformer
implements DmnDataTypeTransformer {
    @Override
    public TypedValue transform(Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            int intValue = this.transformNumber((Number)value);
            return Variables.integerValue((Integer)intValue);
        }
        if (value instanceof String) {
            int intValue = this.transformString((String)value);
            return Variables.integerValue((Integer)intValue);
        }
        throw new IllegalArgumentException();
    }

    protected int transformNumber(Number value) {
        if (this.isInteger(value)) {
            return value.intValue();
        }
        throw new IllegalArgumentException();
    }

    protected boolean isInteger(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((int)doubleValue);
    }

    protected int transformString(String value) {
        return Integer.parseInt(value);
    }
}

