/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.scenario.impl.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.camunda.bpm.scenario.impl.util.Api;
import org.camunda.bpm.scenario.impl.util.Strings;
import org.camunda.bpm.scenario.impl.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Log {
    private static String LOGGER = "org.camunda.bpm.scenario";
    private static ScenarioLog scenarioLog = Api.feature("org.slf4j.Logger").isSupported() ? new Slf4jLog() : new JavaLog();
    private static String space;
    private static String prefix;

    private static String message(Action action, String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId) {
        String message = activityName != null && !activityName.equals("") ? String.format("%s %s %s LABEL(%s @ %s # %s)".replace("LABEL", "'%s' "), prefix, Strings.rightpad(action.toString(), 9), Strings.rightpad(activityType, 18), Strings.trimAll(activityName), activityId, processDefinitionKey, processInstanceId) : String.format("%s %s %s LABEL(%s @ %s # %s)".replace("LABEL", ""), prefix, Strings.rightpad(action.toString(), 9), Strings.rightpad(activityType, 18), activityId, processDefinitionKey, processInstanceId);
        return message;
    }

    static /* synthetic */ String access$200() {
        return LOGGER;
    }

    public static enum Action implements ScenarioLoggable
    {
        StartingAt{

            private void init() {
                space = "";
                prefix = "|";
            }

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                this.init();
                scenarioLog.info(String.format("%s Starting scenario at %s", "*", dateFormat.format(Time.get())));
            }
        }
        ,
        FastForward{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                scenarioLog.info(String.format("%s Fast-forwarding scenario to %s", prefix, dateFormat.format(Time.get())));
                prefix = space + "|--";
                space = space + "  ";
            }
        }
        ,
        FinishingAt{

            private void init() {
                space = "";
                prefix = "|";
            }

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                scenarioLog.info(String.format("%s Finishing scenario at %s", space + "*", dateFormat.format(Time.get())));
                this.init();
            }
        }
        ,
        ActingOn{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                String message = activityName != null ? String.format("%s %s %s LABEL(%s @ %s # %s)".replace("LABEL", "'%s' "), space + "*", Strings.rightpad(this.toString(), 9), Strings.rightpad(activityType, 18), Strings.trimAll(activityName), activityId, processDefinitionKey, processInstanceId) : String.format("%s %s %s LABEL(%s @ %s # %s)".replace("LABEL", ""), space + "*", Strings.rightpad(this.toString(), 9), Strings.rightpad(activityType, 18), activityId, processDefinitionKey, processInstanceId);
                scenarioLog.info(message);
                prefix = space + "|";
            }

            public String toString() {
                return "Acting on";
            }
        }
        ,
        Deferring_Action{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                if (scenarioLog.isDebugEnabled()) {
                    String message = String.format("%s %s %s '%s' until %s (%s @ %s # %s : %s)", prefix, Strings.rightpad("Deferring", 9), Strings.rightpad("action on", 18), Strings.trimAll(activityName), dateFormat.format(time), activityId, processDefinitionKey, processInstanceId, actionId);
                    scenarioLog.debug(message);
                    prefix = space + "|";
                }
            }
        }
        ,
        Executing_Action{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                String message = String.format("%s %s %s '%s' (%s @ %s # %s : %s)", prefix, Strings.rightpad("Executing", 9), Strings.rightpad("deferred action on", 18), Strings.trimAll(activityName), activityId, processDefinitionKey, processInstanceId, actionId);
                scenarioLog.info(message);
                prefix = space + "|";
            }
        }
        ,
        Executing_Job{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                if (scenarioLog.isDebugEnabled()) {
                    String message = String.format("%s %s %s (%s @ %s # %s)", prefix, Strings.rightpad(this.toString(), 9), Strings.rightpad(activityType, 18), Strings.trimAll(activityName), processDefinitionKey, processInstanceId);
                    scenarioLog.debug(message);
                    prefix = space + "|";
                }
            }
        }
        ,
        Started{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                if (scenarioLog.isDebugEnabled()) {
                    scenarioLog.debug(Log.message(this, activityType, activityName, activityId, processDefinitionKey, processInstanceId));
                    prefix = space + "|";
                }
            }
        }
        ,
        Finished{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                scenarioLog.info(Log.message(this, activityType, activityName, activityId, processDefinitionKey, processInstanceId));
                prefix = space + "|";
            }
        }
        ,
        Canceled{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                scenarioLog.info(Log.message(this, activityType, activityName, activityId, processDefinitionKey, processInstanceId));
                prefix = space + "|";
            }
        }
        ,
        Completed{

            @Override
            public void log(String activityType, String activityName, String activityId, String processDefinitionKey, String processInstanceId, String actionId, Date time) {
                scenarioLog.info(Log.message(this, activityType, activityName, activityId, processDefinitionKey, processInstanceId));
                prefix = space + "|";
            }
        };

    }

    private static interface ScenarioLoggable {
        public static final String instanceFormat = "%s %s %s LABEL(%s @ %s # %s)";
        public static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");

        public void log(String var1, String var2, String var3, String var4, String var5, String var6, Date var7);
    }

    private static class JavaLog
    implements ScenarioLog {
        java.util.logging.Logger log = java.util.logging.Logger.getLogger(Log.access$200());

        private JavaLog() {
        }

        @Override
        public boolean isDebugEnabled() {
            return this.log.isLoggable(Level.FINE);
        }

        @Override
        public void debug(String message) {
            this.log.log(Level.FINE, message);
        }

        @Override
        public void info(String message) {
            this.log.log(Level.INFO, message);
        }
    }

    private static class Slf4jLog
    implements ScenarioLog {
        Logger log = LoggerFactory.getLogger((String)Log.access$200());

        private Slf4jLog() {
        }

        @Override
        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        @Override
        public void debug(String message) {
            this.log.debug(message);
        }

        @Override
        public void info(String message) {
            this.log.info(message);
        }
    }

    private static interface ScenarioLog {
        public boolean isDebugEnabled();

        public void debug(String var1);

        public void info(String var1);
    }
}

