/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.listeners;

import java.util.logging.Logger;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunState;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredSequenceFlow;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.IntermediateThrowEvent;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class PathCoverageExecutionListener
implements ExecutionListener {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private CoverageTestRunState coverageTestRunState;

    public PathCoverageExecutionListener(CoverageTestRunState coverageTestRunState) {
        this.coverageTestRunState = coverageTestRunState;
    }

    public void notify(DelegateExecution execution) throws Exception {
        if (this.coverageTestRunState == null) {
            this.logger.warning("Coverage execution listener in use but no coverage run state assigned!");
            return;
        }
        RepositoryService repositoryService = execution.getProcessEngineServices().getRepositoryService();
        ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionId(execution.getProcessDefinitionId()).singleResult();
        String transitionId = execution.getCurrentTransitionId();
        CoveredSequenceFlow coveredSequenceFlow = new CoveredSequenceFlow(processDefinition.getKey(), transitionId);
        this.coverageTestRunState.addCoveredElement(coveredSequenceFlow);
        this.handleEvent(transitionId, processDefinition, repositoryService);
    }

    private void handleEvent(String transitionId, ProcessDefinition processDefinition, RepositoryService repositoryService) {
        BpmnModelInstance modelInstance = repositoryService.getBpmnModelInstance(processDefinition.getId());
        ModelElementInstance modelElement = modelInstance.getModelElementById(transitionId);
        if (modelElement.getElementType().getInstanceType() == SequenceFlow.class) {
            SequenceFlow sequenceFlow = (SequenceFlow)modelElement;
            FlowNode source = sequenceFlow.getSource();
            this.addEventToCoverage(processDefinition, source);
            FlowNode target = sequenceFlow.getTarget();
            this.addEventToCoverage(processDefinition, target);
        }
    }

    private void addEventToCoverage(ProcessDefinition processDefinition, FlowNode node) {
        if (node instanceof IntermediateThrowEvent) {
            CoveredFlowNode coveredElement = new CoveredFlowNode(processDefinition.getKey(), node.getId());
            coveredElement.setEnded(true);
            this.coverageTestRunState.addCoveredElement(coveredElement);
        }
    }
}

