/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.junit.rules;

import org.camunda.bpm.extension.process_test_coverage.model.ProcessCoverage;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class MinimalCoverageMatcher
extends BaseMatcher<Double> {
    double minimalCoverage;

    public MinimalCoverageMatcher(double minimalCoveragePercentage) {
        if (0.0 > minimalCoveragePercentage || minimalCoveragePercentage > 1.0) {
            throw new RuntimeException("ILLEGAL TEST CONFIGURATION: minimal coverage percentage must be between 0.0 and 1.0 (was " + minimalCoveragePercentage + ")");
        }
        this.minimalCoverage = minimalCoveragePercentage;
    }

    public void describeTo(Description description) {
        description.appendText("matches if the coverage ratio is at least ").appendValue((Object)this.minimalCoverage);
    }

    public boolean matches(Object item) {
        return this.actualPercentage(item) >= this.minimalCoverage;
    }

    private double actualPercentage(Object item) {
        if (item instanceof ProcessCoverage) {
            return ((ProcessCoverage)item).getCoveragePercentage();
        }
        if (item instanceof Number) {
            return ((Number)item).doubleValue();
        }
        return -1.0;
    }

    public void describeMismatch(Object item, Description mismatchDescription) {
        if (item instanceof Number || item instanceof ProcessCoverage) {
            mismatchDescription.appendText("coverage of ").appendValue((Object)this.actualPercentage(item));
            mismatchDescription.appendText(" is too low)");
        } else {
            mismatchDescription.appendValue(item).appendText("is not a Number or Coverage");
        }
    }
}

