/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.process_test_coverage.model.AggregatedCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredElement;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredSequenceFlow;
import org.camunda.bpm.extension.process_test_coverage.model.ProcessCoverage;
import org.camunda.bpm.extension.process_test_coverage.util.CoveredElementComparator;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;

public class MethodCoverage
implements AggregatedCoverage {
    private String deploymentId;
    private Map<String, ProcessCoverage> processDefinitionKeyToProcessCoverage = new HashMap<String, ProcessCoverage>();

    public MethodCoverage(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void addProcessCoverage(ProcessCoverage processCoverage) {
        String processDefinitionId = processCoverage.getProcessDefinitionKey();
        this.processDefinitionKeyToProcessCoverage.put(processDefinitionId, processCoverage);
    }

    public void addCoveredElement(CoveredElement element) {
        String processDefinitionKey = element.getProcessDefinitionKey();
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        if (processCoverage != null) {
            processCoverage.addCoveredElement(element);
        }
    }

    public void endCoveredElement(CoveredElement element) {
        String processDefinitionKey = element.getProcessDefinitionKey();
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        if (processCoverage != null) {
            processCoverage.endCoveredElement(element);
        }
    }

    @Override
    public double getCoveragePercentage() {
        HashSet<CoveredFlowNode> deploymentCoveredFlowNodes = new HashSet<CoveredFlowNode>();
        HashSet<FlowNode> deploymentDefinitionsFlowNodes = new HashSet<FlowNode>();
        HashSet<CoveredSequenceFlow> deploymentCoveredSequenceFlows = new HashSet<CoveredSequenceFlow>();
        HashSet<SequenceFlow> deploymentDefinitionsSequenceFlows = new HashSet<SequenceFlow>();
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<CoveredFlowNode> coveredFlowNodes = processCoverage.getCoveredFlowNodes();
            deploymentCoveredFlowNodes.addAll(coveredFlowNodes);
            Set<FlowNode> definitionFlowNodes = processCoverage.getDefinitionFlowNodes();
            deploymentDefinitionsFlowNodes.addAll(definitionFlowNodes);
            Set<CoveredSequenceFlow> coveredSequenceFlows = processCoverage.getCoveredSequenceFlows();
            deploymentCoveredSequenceFlows.addAll(coveredSequenceFlows);
            Set<SequenceFlow> definitionSequenceFlows = processCoverage.getDefinitionSequenceFlows();
            deploymentDefinitionsSequenceFlows.addAll(definitionSequenceFlows);
        }
        double coveragePercentage = this.getCoveragePercentage(deploymentCoveredFlowNodes, deploymentDefinitionsFlowNodes, deploymentCoveredSequenceFlows, deploymentDefinitionsSequenceFlows);
        return coveragePercentage;
    }

    @Override
    public double getCoveragePercentage(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        Set<CoveredFlowNode> coveredFlowNodes = processCoverage.getCoveredFlowNodes();
        Set<FlowNode> definitionFlowNodes = processCoverage.getDefinitionFlowNodes();
        Set<CoveredSequenceFlow> coveredSequenceFlows = processCoverage.getCoveredSequenceFlows();
        Set<SequenceFlow> definitionSequenceFlows = processCoverage.getDefinitionSequenceFlows();
        double coveragePercentage = this.getCoveragePercentage(coveredFlowNodes, definitionFlowNodes, coveredSequenceFlows, definitionSequenceFlows);
        return coveragePercentage;
    }

    private double getCoveragePercentage(Set<CoveredFlowNode> coveredFlowNodes, Set<FlowNode> definitionsFlowNodes, Set<CoveredSequenceFlow> coveredSequenceFlows, Set<SequenceFlow> definitionsSequenceFlows) {
        int numberOfDefinedElements = definitionsFlowNodes.size() + definitionsSequenceFlows.size();
        int numberOfCoveredElemenets = coveredFlowNodes.size() + coveredSequenceFlows.size();
        return (double)numberOfCoveredElemenets / (double)numberOfDefinedElements;
    }

    public Set<FlowNode> getProcessDefinitionsFlowNodes() {
        HashSet<FlowNode> flowNodes = new HashSet<FlowNode>();
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<FlowNode> definitionFlowNodes = processCoverage.getDefinitionFlowNodes();
            flowNodes.addAll(definitionFlowNodes);
        }
        return flowNodes;
    }

    public Set<FlowNode> getProcessDefinitionsFlowNodes(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        Set<FlowNode> definitionFlowNodes = processCoverage.getDefinitionFlowNodes();
        return definitionFlowNodes;
    }

    public Set<SequenceFlow> getProcessDefinitionsSequenceFlows() {
        HashSet<SequenceFlow> sequenceFlows = new HashSet<SequenceFlow>();
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<SequenceFlow> definitionSequenceFlows = processCoverage.getDefinitionSequenceFlows();
            sequenceFlows.addAll(definitionSequenceFlows);
        }
        return sequenceFlows;
    }

    public Set<SequenceFlow> getProcessDefinitionsSequenceFlows(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        Set<SequenceFlow> sequenceFlows = processCoverage.getDefinitionSequenceFlows();
        return sequenceFlows;
    }

    public Set<CoveredFlowNode> getCoveredFlowNodes() {
        TreeSet<CoveredElement> flowNodes = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<CoveredFlowNode> definitionFlowNodes = processCoverage.getCoveredFlowNodes();
            flowNodes.addAll(definitionFlowNodes);
        }
        return flowNodes;
    }

    public Set<CoveredSequenceFlow> getCoveredSequenceFlows() {
        TreeSet<CoveredElement> sequenceFlows = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            Set<CoveredSequenceFlow> definitionSequenceFlows = processCoverage.getCoveredSequenceFlows();
            sequenceFlows.addAll(definitionSequenceFlows);
        }
        return sequenceFlows;
    }

    @Override
    public Set<String> getCoveredFlowNodeIds(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        if (processCoverage != null) {
            return processCoverage.getCoveredFlowNodeIds();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CoveredFlowNode> getCoveredFlowNodes(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        if (processCoverage != null) {
            return processCoverage.getCoveredFlowNodes();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getCoveredSequenceFlowIds(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        if (processCoverage != null) {
            return processCoverage.getCoveredSequenceFlowIds();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<CoveredSequenceFlow> getCoveredSequenceFlows(String processDefinitionKey) {
        ProcessCoverage processCoverage = this.processDefinitionKeyToProcessCoverage.get(processDefinitionKey);
        return processCoverage.getCoveredSequenceFlows();
    }

    @Override
    public Set<ProcessDefinition> getProcessDefinitions() {
        TreeSet<ProcessDefinition> processDefinitions = new TreeSet<ProcessDefinition>(new Comparator<ProcessDefinition>(){

            @Override
            public int compare(ProcessDefinition o1, ProcessDefinition o2) {
                return o1.getResourceName().compareTo(o2.getResourceName());
            }
        });
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            processDefinitions.add(processCoverage.getProcessDefinition());
        }
        return processDefinitions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Deployment ID: ");
        builder.append(this.deploymentId);
        builder.append("\nDeployment process definitions:\n");
        for (ProcessCoverage processCoverage : this.processDefinitionKeyToProcessCoverage.values()) {
            builder.append(processCoverage);
            builder.append('\n');
        }
        return builder.toString();
    }
}

