/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunState;
import org.camunda.bpm.extension.process_test_coverage.model.AggregatedCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.ClassCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.model.MethodCoverage;
import org.camunda.bpm.extension.process_test_coverage.util.BpmnJsReport;
import org.camunda.bpm.extension.process_test_coverage.util.ClassLocationURL;

public class CoverageReportUtil {
    private static final Logger logger = Logger.getLogger(CoverageReportUtil.class.getCanonicalName());
    public static String TARGET_DIR_ROOT = System.getProperty("camunda-bpm-process-test-coverage.target-dir-root", "target/process-test-coverage/");
    public static final String BOWER_DIR_NAME = "bower_components";

    public static void createClassReport(CoverageTestRunState coverageTestRunState) {
        ClassCoverage coverage = coverageTestRunState.getClassCoverage();
        String reportDirectory = CoverageReportUtil.getReportDirectoryPath(coverageTestRunState.getTestClassName());
        CoverageReportUtil.createReport(coverage, reportDirectory, coverageTestRunState.getTestClassName(), null);
    }

    public static void createCurrentTestMethodReport(CoverageTestRunState coverageTestRunState) {
        MethodCoverage coverage = coverageTestRunState.getCurrentTestMethodCoverage();
        String reportDirectory = CoverageReportUtil.getReportDirectoryPath(coverageTestRunState.getTestClassName());
        CoverageReportUtil.createReport(coverage, reportDirectory, coverageTestRunState.getTestClassName(), coverageTestRunState.getCurrentTestMethodName());
    }

    public static void createReport(AggregatedCoverage coverage, String reportDirectory) {
        CoverageReportUtil.createReport(coverage, reportDirectory, null, null);
    }

    private static void createReport(AggregatedCoverage coverage, String reportDirectory, String testClass, String testName) {
        CoverageReportUtil.installBowerComponents(reportDirectory);
        Set<ProcessDefinition> processDefinitions = coverage.getProcessDefinitions();
        for (ProcessDefinition processDefinition : processDefinitions) {
            try {
                Set<CoveredFlowNode> coveredFlowNodes = coverage.getCoveredFlowNodes(processDefinition.getKey());
                Set<String> coveredSequenceFlowIds = coverage.getCoveredSequenceFlowIds(processDefinition.getKey());
                String reportName = CoverageReportUtil.getReportName(processDefinition, testName);
                String bpmnXml = CoverageReportUtil.getBpmnXml(processDefinition);
                BpmnJsReport.generateReportWithHighlightedFlowNodesAndSequenceFlows(bpmnXml, coveredFlowNodes, coveredSequenceFlowIds, reportDirectory + '/' + reportName, processDefinition.getKey(), coverage.getCoveragePercentage(processDefinition.getKey()), testClass, testName);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Unable to load process definition!", ex);
                throw new RuntimeException();
            }
        }
    }

    private static void installBowerComponents(String reportDirectory) {
        File parent = new File(reportDirectory).getParentFile();
        File bowerComponents = new File(parent, BOWER_DIR_NAME);
        if (bowerComponents.exists()) {
            return;
        }
        try {
            File resourcesRoot = ClassLocationURL.fileFor(CoverageReportUtil.class);
            if (resourcesRoot.isFile()) {
                JarFile coverageJar = new JarFile(resourcesRoot);
                Enumeration<JarEntry> entries = coverageJar.entries();
                while (entries.hasMoreElements()) {
                    String resourcePath = entries.nextElement().getName();
                    if (!resourcePath.startsWith(BOWER_DIR_NAME)) continue;
                    File resource = new File(parent, resourcePath);
                    InputStream source = CoverageReportUtil.class.getResourceAsStream("/" + resourcePath);
                    if (resourcePath.endsWith("/")) {
                        resource.mkdirs();
                        continue;
                    }
                    resource.getParentFile().mkdirs();
                    FileUtils.copyInputStreamToFile((InputStream)source, (File)resource);
                }
                coverageJar.close();
            } else {
                File bowerSrc = new File(CoverageReportUtil.class.getResource("/bower_components").toURI());
                FileUtils.copyDirectory((File)bowerSrc, (File)bowerComponents);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to copy bower_components!", e);
        }
    }

    private static String getReportDirectoryPath(String className) {
        return TARGET_DIR_ROOT + className;
    }

    private static String getReportName(ProcessDefinition processDefinition, String reportNamePrefix) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)reportNamePrefix)) {
            builder.append(reportNamePrefix);
            builder.append('_');
        }
        builder.append(processDefinition.getKey());
        builder.append(".html");
        return builder.toString();
    }

    protected static String getBpmnXml(ProcessDefinition processDefinition) throws IOException {
        InputStream inputStream = CoverageReportUtil.class.getClassLoader().getResourceAsStream(processDefinition.getResourceName());
        if (inputStream == null) {
            inputStream = new FileInputStream(processDefinition.getResourceName());
        }
        return IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
    }

    public static void setReportDirectory(String reportDirectory) {
        TARGET_DIR_ROOT = reportDirectory;
    }
}

