/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.identity.impl.ldap;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.identity.impl.ldap.LdapAuthenticationException;
import org.camunda.bpm.identity.impl.ldap.LdapConfiguration;
import org.camunda.bpm.identity.impl.ldap.LdapSearchResults;
import org.camunda.bpm.identity.impl.ldap.util.LdapPluginLogger;

public class LdapClient {
    protected LdapContext initialContext;
    protected LdapConfiguration ldapConfiguration;

    public LdapClient(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    protected void ensureContextInitialized() {
        if (this.initialContext == null) {
            this.initialContext = this.openContext();
        }
    }

    public LdapContext openContext(String dn, String password) {
        Map<String, String> contextProperties;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.ldapConfiguration.getInitialContextFactory());
        env.put("java.naming.security.authentication", this.ldapConfiguration.getSecurityAuthentication());
        env.put("java.naming.provider.url", this.ldapConfiguration.getServerUrl());
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", password);
        if (this.ldapConfiguration.isAllowAnonymousLogin() && password.isEmpty()) {
            env.put("java.naming.security.authentication", "none");
        }
        if (this.ldapConfiguration.isUseSsl()) {
            env.put("java.naming.security.protocol", "ssl");
        }
        if ((contextProperties = this.ldapConfiguration.getContextProperties()) != null) {
            env.putAll(contextProperties);
        }
        try {
            return new InitialLdapContext(env, null);
        }
        catch (AuthenticationException e) {
            throw new LdapAuthenticationException("Could not authenticate with LDAP server", e);
        }
        catch (NamingException e) {
            throw new IdentityProviderException("Could not connect to LDAP server", (Throwable)e);
        }
    }

    protected LdapContext openContext() {
        return this.openContext(this.ldapConfiguration.getManagerDn(), this.ldapConfiguration.getManagerPassword());
    }

    protected void closeLdapCtx() {
        this.closeLdapCtx(this.initialContext);
    }

    protected void closeLdapCtx(LdapContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException e) {
                LdapPluginLogger.INSTANCE.exceptionWhenClosingLdapContext(e);
            }
        }
    }

    public LdapSearchResults search(String baseDn, String searchFilter) {
        try {
            return new LdapSearchResults(this.initialContext.search(baseDn, searchFilter, this.ldapConfiguration.getSearchControls()));
        }
        catch (NamingException e) {
            throw new IdentityProviderException("LDAP search request failed.", (Throwable)e);
        }
    }

    public void setRequestControls(List<Control> listControls) {
        try {
            this.initialContext.setRequestControls(listControls.toArray(new Control[0]));
        }
        catch (NamingException e) {
            throw new IdentityProviderException("LDAP server failed to set request controls.", (Throwable)e);
        }
    }

    public Control[] getResponseControls() {
        try {
            return this.initialContext.getResponseControls();
        }
        catch (NamingException e) {
            throw new IdentityProviderException("Error occurred while getting the response controls from the LDAP server.", (Throwable)e);
        }
    }

    public static void addPaginationControl(List<Control> listControls, byte[] cookie, Integer pageSize) {
        try {
            listControls.add(new PagedResultsControl(pageSize, cookie, false));
        }
        catch (IOException e) {
            throw new IdentityProviderException("Pagination couldn't be enabled.", (Throwable)e);
        }
    }

    public static void addSortKey(SortKey sortKey, List<Control> controls) {
        try {
            controls.add(new SortControl(new SortKey[]{sortKey}, true));
        }
        catch (IOException e) {
            throw new IdentityProviderException("Sorting couldn't be enabled.", (Throwable)e);
        }
    }

    protected static String getValue(String attrName, Attributes attributes) {
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            try {
                return (String)attribute.get();
            }
            catch (NamingException e) {
                throw new IdentityProviderException("Error occurred while retrieving the value.", (Throwable)e);
            }
        }
        return null;
    }

    public static NamingEnumeration<String> getAllMembers(String attributeId, LdapSearchResults searchResults) {
        Attribute memberAttribute;
        SearchResult result = searchResults.nextElement();
        Attributes attributes = result.getAttributes();
        if (attributes != null && (memberAttribute = attributes.get(attributeId)) != null) {
            try {
                return memberAttribute.getAll();
            }
            catch (NamingException e) {
                throw new IdentityProviderException("Value couldn't be retrieved.", (Throwable)e);
            }
        }
        return null;
    }
}

