/*
 * Copyright © 2014 - 2018 camunda services GmbH and various authors (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.model.bpmn.impl.instance;

import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.Property;
import org.camunda.bpm.model.bpmn.instance.bpmndi.BpmnShape;
import org.camunda.bpm.model.xml.ModelBuilder;
import org.camunda.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.camunda.bpm.model.xml.type.ModelElementTypeBuilder;
import org.camunda.bpm.model.xml.type.child.ChildElementCollection;
import org.camunda.bpm.model.xml.type.child.SequenceBuilder;

import java.util.Collection;

import static org.camunda.bpm.model.bpmn.impl.BpmnModelConstants.BPMN20_NS;
import static org.camunda.bpm.model.bpmn.impl.BpmnModelConstants.BPMN_ELEMENT_EVENT;

/**
 * The BPMN event element
 *
 * @author Sebastian Menski
 *
 */
public abstract class EventImpl extends FlowNodeImpl implements Event {

  protected static ChildElementCollection<Property> propertyCollection;

  public static void registerType(ModelBuilder modelBuilder) {
    ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(Event.class, BPMN_ELEMENT_EVENT)
      .namespaceUri(BPMN20_NS)
      .extendsType(FlowNode.class)
      .abstractType();

    SequenceBuilder sequence = typeBuilder.sequence();

    propertyCollection = sequence.elementCollection(Property.class)
      .build();

    typeBuilder.build();
  }

  public EventImpl(ModelTypeInstanceContext context) {
    super(context);
  }

  public Collection<Property> getProperties() {
    return propertyCollection.get(this);
  }

  public BpmnShape getDiagramElement() {
    return (BpmnShape) super.getDiagramElement();
  }

}
