/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.bpmn.builder;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.BpmnModelException;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractBpmnModelElementBuilder;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.CompensateEventDefinition;
import org.camunda.bpm.model.bpmn.instance.Definitions;
import org.camunda.bpm.model.bpmn.instance.Error;
import org.camunda.bpm.model.bpmn.instance.ErrorEventDefinition;
import org.camunda.bpm.model.bpmn.instance.Escalation;
import org.camunda.bpm.model.bpmn.instance.EscalationEventDefinition;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.Message;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.Signal;
import org.camunda.bpm.model.bpmn.instance.SignalEventDefinition;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class AbstractBaseElementBuilder<B extends AbstractBaseElementBuilder<B, E>, E extends BaseElement>
extends AbstractBpmnModelElementBuilder<B, E> {
    protected AbstractBaseElementBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    protected <T extends BpmnModelElementInstance> T createInstance(Class<T> typeClass) {
        return (T)((BpmnModelElementInstance)this.modelInstance.newInstance(typeClass));
    }

    protected <T extends BaseElement> T createInstance(Class<T> typeClass, String identifier) {
        BaseElement instance = (BaseElement)this.createInstance(typeClass);
        if (identifier != null) {
            instance.setId(identifier);
        }
        return (T)instance;
    }

    protected <T extends BpmnModelElementInstance> T createChild(Class<T> typeClass) {
        return this.createChild(this.element, typeClass);
    }

    protected <T extends BaseElement> T createChild(Class<T> typeClass, String identifier) {
        return this.createChild(this.element, typeClass, identifier);
    }

    protected <T extends BpmnModelElementInstance> T createChild(BpmnModelElementInstance parent, Class<T> typeClass) {
        T instance = this.createInstance(typeClass);
        parent.addChildElement((ModelElementInstance)instance);
        return instance;
    }

    protected <T extends BaseElement> T createChild(BpmnModelElementInstance parent, Class<T> typeClass, String identifier) {
        T instance = this.createInstance(typeClass, identifier);
        parent.addChildElement((ModelElementInstance)instance);
        return instance;
    }

    protected <T extends BpmnModelElementInstance> T createSibling(Class<T> typeClass) {
        T instance = this.createInstance(typeClass);
        ((BaseElement)this.element).getParentElement().addChildElement(instance);
        return instance;
    }

    protected <T extends BaseElement> T createSibling(Class<T> typeClass, String identifier) {
        T instance = this.createInstance(typeClass, identifier);
        ((BaseElement)this.element).getParentElement().addChildElement(instance);
        return instance;
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleChild(Class<T> typeClass) {
        return this.getCreateSingleChild(this.element, typeClass);
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleChild(BpmnModelElementInstance parent, Class<T> typeClass) {
        Collection childrenOfType = parent.getChildElementsByType(typeClass);
        if (childrenOfType.isEmpty()) {
            return this.createChild(parent, typeClass);
        }
        if (childrenOfType.size() > 1) {
            throw new BpmnModelException("Element " + parent + " of type " + parent.getElementType().getTypeName() + " has more than one child element of type " + typeClass.getName());
        }
        return (T)((BpmnModelElementInstance)childrenOfType.iterator().next());
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleExtensionElement(Class<T> typeClass) {
        ExtensionElements extensionElements = this.getCreateSingleChild(ExtensionElements.class);
        return this.getCreateSingleChild(extensionElements, typeClass);
    }

    protected Message findMessageForName(String messageName) {
        Message message2;
        Collection messages = this.modelInstance.getModelElementsByType(Message.class);
        for (Message message2 : messages) {
            if (!messageName.equals(message2.getName())) continue;
            return message2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        message2 = this.createChild(definitions, Message.class);
        message2.setName(messageName);
        return message2;
    }

    protected MessageEventDefinition createMessageEventDefinition(String messageName) {
        Message message = this.findMessageForName(messageName);
        MessageEventDefinition messageEventDefinition = this.createInstance(MessageEventDefinition.class);
        messageEventDefinition.setMessage(message);
        return messageEventDefinition;
    }

    protected MessageEventDefinition createEmptyMessageEventDefinition() {
        return this.createInstance(MessageEventDefinition.class);
    }

    protected Signal findSignalForName(String signalName) {
        Signal signal2;
        Collection signals = this.modelInstance.getModelElementsByType(Signal.class);
        for (Signal signal2 : signals) {
            if (!signalName.equals(signal2.getName())) continue;
            return signal2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        signal2 = this.createChild(definitions, Signal.class);
        signal2.setName(signalName);
        return signal2;
    }

    protected SignalEventDefinition createSignalEventDefinition(String signalName) {
        Signal signal = this.findSignalForName(signalName);
        SignalEventDefinition signalEventDefinition = this.createInstance(SignalEventDefinition.class);
        signalEventDefinition.setSignal(signal);
        return signalEventDefinition;
    }

    protected ErrorEventDefinition findErrorDefinitionForCode(String errorCode) {
        Collection definitions = this.modelInstance.getModelElementsByType(ErrorEventDefinition.class);
        for (ErrorEventDefinition definition : definitions) {
            Error error = definition.getError();
            if (error == null || !error.getErrorCode().equals(errorCode)) continue;
            return definition;
        }
        return null;
    }

    protected Error findErrorForNameAndCode(String errorCode) {
        Error error2;
        Collection errors = this.modelInstance.getModelElementsByType(Error.class);
        for (Error error2 : errors) {
            if (!errorCode.equals(error2.getErrorCode())) continue;
            return error2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        error2 = this.createChild(definitions, Error.class);
        error2.setErrorCode(errorCode);
        return error2;
    }

    protected ErrorEventDefinition createEmptyErrorEventDefinition() {
        ErrorEventDefinition errorEventDefinition = this.createInstance(ErrorEventDefinition.class);
        return errorEventDefinition;
    }

    protected ErrorEventDefinition createErrorEventDefinition(String errorCode) {
        Error error = this.findErrorForNameAndCode(errorCode);
        ErrorEventDefinition errorEventDefinition = this.createInstance(ErrorEventDefinition.class);
        errorEventDefinition.setError(error);
        return errorEventDefinition;
    }

    protected Escalation findEscalationForCode(String escalationCode) {
        Escalation escalation2;
        Collection escalations = this.modelInstance.getModelElementsByType(Escalation.class);
        for (Escalation escalation2 : escalations) {
            if (!escalationCode.equals(escalation2.getEscalationCode())) continue;
            return escalation2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        escalation2 = this.createChild(definitions, Escalation.class);
        escalation2.setEscalationCode(escalationCode);
        return escalation2;
    }

    protected EscalationEventDefinition createEscalationEventDefinition(String escalationCode) {
        Escalation escalation = this.findEscalationForCode(escalationCode);
        EscalationEventDefinition escalationEventDefinition = this.createInstance(EscalationEventDefinition.class);
        escalationEventDefinition.setEscalation(escalation);
        return escalationEventDefinition;
    }

    protected CompensateEventDefinition createCompensateEventDefinition() {
        CompensateEventDefinition compensateEventDefinition = this.createInstance(CompensateEventDefinition.class);
        return compensateEventDefinition;
    }

    public B id(String identifier) {
        ((BaseElement)this.element).setId(identifier);
        return (B)((AbstractBaseElementBuilder)this.myself);
    }

    public B addExtensionElement(BpmnModelElementInstance extensionElement) {
        ExtensionElements extensionElements = this.getCreateSingleChild(ExtensionElements.class);
        extensionElements.addChildElement(extensionElement);
        return (B)((AbstractBaseElementBuilder)this.myself);
    }
}

