/*
 * Copyright © 2014 - 2018 camunda services GmbH and various authors (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.model.xml;

import java.util.Collection;

/**
 * Exception thrown if a user attempts to perform an unsupported
 * model operation. Example: call {@link Collection#add(Object)} on an
 * immutable collection.
 *
 * @author Daniel Meyer
 *
 */
public class UnsupportedModelOperationException extends UnsupportedOperationException {

  private static final long serialVersionUID = 1L;

  public UnsupportedModelOperationException(String operationName, String reason) {
    super("The operation " + operationName + " is unsupported: " + reason + ".");
  }

}
