/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.spring.boot.starter.impl;

import org.camunda.bpm.client.interceptor.auth.BasicAuthProvider;
import org.camunda.bpm.client.spring.boot.starter.BasicAuthProperties;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.spring.impl.client.ClientConfiguration;
import org.camunda.bpm.client.spring.impl.client.ClientFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PropertiesAwareClientFactory
extends ClientFactory {
    @Autowired
    protected ClientProperties clientProperties;

    public void afterPropertiesSet() throws Exception {
        this.applyPropertiesFrom(this.clientProperties);
        this.addBasicAuthInterceptor();
        super.afterPropertiesSet();
    }

    protected void addBasicAuthInterceptor() {
        BasicAuthProperties basicAuth = this.clientProperties.getBasicAuth();
        if (basicAuth != null) {
            String username = basicAuth.getUsername();
            String password = basicAuth.getPassword();
            BasicAuthProvider basicAuthProvider = new BasicAuthProvider(username, password);
            this.getRequestInterceptors().add(basicAuthProvider);
        }
    }

    public void applyPropertiesFrom(ClientProperties clientConfigurationProps) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (clientConfigurationProps.getBaseUrl() != null) {
            clientConfiguration.setBaseUrl(clientConfigurationProps.getBaseUrl());
        }
        if (clientConfigurationProps.getWorkerId() != null) {
            clientConfiguration.setWorkerId(clientConfigurationProps.getWorkerId());
        }
        if (clientConfigurationProps.getMaxTasks() != null) {
            clientConfiguration.setMaxTasks(clientConfigurationProps.getMaxTasks());
        }
        if (clientConfigurationProps.getUsePriority() != null && !clientConfigurationProps.getUsePriority().booleanValue()) {
            clientConfiguration.setUsePriority(Boolean.valueOf(false));
        }
        if (clientConfigurationProps.getDefaultSerializationFormat() != null) {
            clientConfiguration.setDefaultSerializationFormat(clientConfigurationProps.getDefaultSerializationFormat());
        }
        if (clientConfigurationProps.getDateFormat() != null) {
            clientConfiguration.setDateFormat(clientConfigurationProps.getDateFormat());
        }
        if (clientConfigurationProps.getLockDuration() != null) {
            clientConfiguration.setLockDuration(clientConfigurationProps.getLockDuration());
        }
        if (clientConfigurationProps.getAsyncResponseTimeout() != null) {
            clientConfiguration.setAsyncResponseTimeout(clientConfigurationProps.getAsyncResponseTimeout());
        }
        if (clientConfigurationProps.getDisableAutoFetching() != null && clientConfigurationProps.getDisableAutoFetching().booleanValue()) {
            clientConfiguration.setDisableAutoFetching(Boolean.valueOf(true));
        }
        if (clientConfigurationProps.getDisableBackoffStrategy() != null && clientConfigurationProps.getDisableBackoffStrategy().booleanValue()) {
            clientConfiguration.setDisableBackoffStrategy(Boolean.valueOf(true));
        }
        this.setClientConfiguration(clientConfiguration);
    }
}

