/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.property;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringJoiner;
import org.apache.commons.lang3.RandomStringUtils;
import org.camunda.bpm.spring.boot.starter.property.AdminUserProperty;
import org.camunda.bpm.spring.boot.starter.property.AuthorizationProperty;
import org.camunda.bpm.spring.boot.starter.property.DatabaseProperty;
import org.camunda.bpm.spring.boot.starter.property.Defaults;
import org.camunda.bpm.spring.boot.starter.property.EventingProperty;
import org.camunda.bpm.spring.boot.starter.property.FilterProperty;
import org.camunda.bpm.spring.boot.starter.property.GenericProperties;
import org.camunda.bpm.spring.boot.starter.property.JobExecutionProperty;
import org.camunda.bpm.spring.boot.starter.property.MetricsProperty;
import org.camunda.bpm.spring.boot.starter.property.RestApiProperty;
import org.camunda.bpm.spring.boot.starter.property.WebappProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="camunda.bpm")
public class CamundaBpmProperties {
    public static final String PREFIX = "camunda.bpm";
    public static final String UNIQUE_ENGINE_NAME_PREFIX = "processEngine";
    public static final String UNIQUE_APPLICATION_NAME_PREFIX = "processApplication";
    public static final String[] DEFAULT_BPMN_RESOURCE_SUFFIXES = new String[]{"bpmn20.xml", "bpmn"};
    public static final String[] DEFAULT_CMMN_RESOURCE_SUFFIXES = new String[]{"cmmn11.xml", "cmmn10.xml", "cmmn"};
    public static final String[] DEFAULT_DMN_RESOURCE_SUFFIXES = new String[]{"dmn11.xml", "dmn"};
    private String processEngineName = "default";
    private Boolean generateUniqueProcessEngineName = false;
    private Boolean generateUniqueProcessApplicationName = false;
    private String idGenerator = "strong";
    private Boolean jobExecutorAcquireByPriority = null;
    private Integer defaultNumberOfRetries = null;
    private String historyLevel = "full";
    private String historyLevelDefault = "full";
    private boolean autoDeploymentEnabled = true;
    private String[] deploymentResourcePattern = CamundaBpmProperties.initDeploymentResourcePattern();
    private String defaultSerializationFormat = Defaults.INSTANCE.getDefaultSerializationFormat();
    private URL licenseFile;
    private boolean enabled = true;
    @NestedConfigurationProperty
    private MetricsProperty metrics = new MetricsProperty();
    @NestedConfigurationProperty
    private DatabaseProperty database = new DatabaseProperty();
    @NestedConfigurationProperty
    private EventingProperty eventing = new EventingProperty();
    @NestedConfigurationProperty
    private JobExecutionProperty jobExecution = new JobExecutionProperty();
    @NestedConfigurationProperty
    private WebappProperty webapp = new WebappProperty();
    @NestedConfigurationProperty
    private RestApiProperty restApi = new RestApiProperty();
    @NestedConfigurationProperty
    private AuthorizationProperty authorization = new AuthorizationProperty();
    @NestedConfigurationProperty
    private GenericProperties genericProperties = new GenericProperties();
    @NestedConfigurationProperty
    private AdminUserProperty adminUser = new AdminUserProperty();
    @NestedConfigurationProperty
    private FilterProperty filter = new FilterProperty();

    static String[] initDeploymentResourcePattern() {
        HashSet<String> suffixes = new HashSet<String>();
        suffixes.addAll(Arrays.asList(DEFAULT_DMN_RESOURCE_SUFFIXES));
        suffixes.addAll(Arrays.asList(DEFAULT_BPMN_RESOURCE_SUFFIXES));
        suffixes.addAll(Arrays.asList(DEFAULT_CMMN_RESOURCE_SUFFIXES));
        HashSet<String> patterns = new HashSet<String>();
        for (String suffix : suffixes) {
            patterns.add(String.format("%s**/*.%s", "classpath*:", suffix));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    static StringJoiner joinOn(Class<?> clazz) {
        return new StringJoiner(", ", clazz.getSimpleName() + "[", "]");
    }

    public static String getUniqueName(String name) {
        return name + RandomStringUtils.randomAlphanumeric((int)10);
    }

    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public void setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
    }

    public String getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(String historyLevel) {
        this.historyLevel = historyLevel;
    }

    public String getHistoryLevelDefault() {
        return this.historyLevelDefault;
    }

    public void setHistoryLevelDefault(String historyLevelDefault) {
        this.historyLevelDefault = historyLevelDefault;
    }

    public boolean isAutoDeploymentEnabled() {
        return this.autoDeploymentEnabled;
    }

    public void setAutoDeploymentEnabled(boolean autoDeploymentEnabled) {
        this.autoDeploymentEnabled = autoDeploymentEnabled;
    }

    public String[] getDeploymentResourcePattern() {
        return this.deploymentResourcePattern;
    }

    public void setDeploymentResourcePattern(String[] deploymentResourcePattern) {
        this.deploymentResourcePattern = deploymentResourcePattern;
    }

    public String getDefaultSerializationFormat() {
        return this.defaultSerializationFormat;
    }

    public void setDefaultSerializationFormat(String defaultSerializationFormat) {
        this.defaultSerializationFormat = defaultSerializationFormat;
    }

    public URL getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(URL licenseFile) {
        this.licenseFile = licenseFile;
    }

    public MetricsProperty getMetrics() {
        return this.metrics;
    }

    public void setMetrics(MetricsProperty metrics) {
        this.metrics = metrics;
    }

    public DatabaseProperty getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseProperty database) {
        this.database = database;
    }

    public EventingProperty getEventing() {
        return this.eventing;
    }

    public void setEventing(EventingProperty eventing) {
        this.eventing = eventing;
    }

    public JobExecutionProperty getJobExecution() {
        return this.jobExecution;
    }

    public void setJobExecution(JobExecutionProperty jobExecution) {
        this.jobExecution = jobExecution;
    }

    public WebappProperty getWebapp() {
        return this.webapp;
    }

    public void setWebapp(WebappProperty webapp) {
        this.webapp = webapp;
    }

    public RestApiProperty getRestApi() {
        return this.restApi;
    }

    public void setRestApi(RestApiProperty restApi) {
        this.restApi = restApi;
    }

    public AuthorizationProperty getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(AuthorizationProperty authorization) {
        this.authorization = authorization;
    }

    public GenericProperties getGenericProperties() {
        return this.genericProperties;
    }

    public void setGenericProperties(GenericProperties genericProperties) {
        this.genericProperties = genericProperties;
    }

    public AdminUserProperty getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(AdminUserProperty adminUser) {
        this.adminUser = adminUser;
    }

    public FilterProperty getFilter() {
        return this.filter;
    }

    public void setFilter(FilterProperty filter) {
        this.filter = filter;
    }

    public String getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(String idGenerator) {
        this.idGenerator = idGenerator;
    }

    public Boolean getJobExecutorAcquireByPriority() {
        return this.jobExecutorAcquireByPriority;
    }

    public void setJobExecutorAcquireByPriority(Boolean jobExecutorAcquireByPriority) {
        this.jobExecutorAcquireByPriority = jobExecutorAcquireByPriority;
    }

    public Integer getDefaultNumberOfRetries() {
        return this.defaultNumberOfRetries;
    }

    public void setDefaultNumberOfRetries(Integer defaultNumberOfRetries) {
        this.defaultNumberOfRetries = defaultNumberOfRetries;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getGenerateUniqueProcessEngineName() {
        return this.generateUniqueProcessEngineName;
    }

    public void setGenerateUniqueProcessEngineName(Boolean generateUniqueProcessEngineName) {
        this.generateUniqueProcessEngineName = generateUniqueProcessEngineName;
    }

    public Boolean getGenerateUniqueProcessApplicationName() {
        return this.generateUniqueProcessApplicationName;
    }

    public void setGenerateUniqueProcessApplicationName(Boolean generateUniqueProcessApplicationName) {
        this.generateUniqueProcessApplicationName = generateUniqueProcessApplicationName;
    }

    public String toString() {
        return CamundaBpmProperties.joinOn(this.getClass()).add("enabled=" + this.enabled).add("processEngineName=" + this.processEngineName).add("generateUniqueProcessEngineName=" + this.generateUniqueProcessEngineName).add("generateUniqueProcessApplicationName=" + this.generateUniqueProcessApplicationName).add("historyLevel=" + this.historyLevel).add("historyLevelDefault=" + this.historyLevelDefault).add("autoDeploymentEnabled=" + this.autoDeploymentEnabled).add("deploymentResourcePattern=" + Arrays.toString(this.deploymentResourcePattern)).add("defaultSerializationFormat=" + this.defaultSerializationFormat).add("licenseFile=" + this.licenseFile).add("metrics=" + this.metrics).add("database=" + this.database).add("jobExecution=" + this.jobExecution).add("webapp=" + this.webapp).add("restApi=" + this.restApi).add("authorization=" + this.authorization).add("genericProperties=" + this.genericProperties).add("adminUser=" + this.adminUser).add("filter=" + this.filter).add("idGenerator=" + this.idGenerator).add("jobExecutorAcquireByPriority=" + this.jobExecutorAcquireByPriority).add("defaultNumberOfRetries" + this.defaultNumberOfRetries).toString();
    }
}

