/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.filter;

import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.camunda.bpm.webapp.impl.security.auth.Authentication;
import org.camunda.bpm.webapp.impl.security.auth.UserAuthentication;

public class Authorization {
    private final Authentication authentication;
    private final boolean granted;
    private String application;

    public Authorization(Authentication authentication, boolean granted) {
        this.authentication = authentication;
        this.granted = granted;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public boolean isGranted() {
        return this.granted;
    }

    public Authorization forApplication(String application) {
        this.application = application;
        return this;
    }

    public void attachHeaders(HttpServletResponse response) {
        if (this.authentication != null) {
            if (this.authentication.getIdentityId() != null) {
                response.addHeader("X-Authorized-User", this.authentication.getIdentityId());
            }
            if (this.authentication.getProcessEngineName() != null) {
                response.addHeader("X-Authorized-Engine", this.authentication.getProcessEngineName());
            }
            if (this.authentication instanceof UserAuthentication) {
                response.addHeader("X-Authorized-Apps", Authorization.join(",", ((UserAuthentication)this.authentication).getAuthorizedApps()));
            }
        }
    }

    public boolean isAuthenticated() {
        return this.authentication != null && this.authentication != Authentication.ANONYMOUS;
    }

    public String getApplication() {
        return this.application;
    }

    public static Authorization granted(Authentication authentication) {
        return new Authorization(authentication, true);
    }

    public static Authorization denied(Authentication authentication) {
        return new Authorization(authentication, false);
    }

    public static Authorization grantedUnlessNull(Authentication authentication) {
        return authentication != null ? Authorization.granted(authentication) : Authorization.denied(authentication);
    }

    private static String join(String delimiter, Collection<?> collection) {
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(o);
        }
        return builder.toString();
    }
}

