/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.plugin.base.dto.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.ProcessInstanceDto;
import org.camunda.bpm.cockpit.rest.dto.AbstractRestQueryParametersDto;
import org.camunda.bpm.engine.impl.QueryVariableValue;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.ConditionQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;

public abstract class AbstractProcessInstanceQueryDto<T extends ProcessInstanceDto>
extends AbstractRestQueryParametersDto<T> {
    private static final long serialVersionUID = 1L;
    private static final String SORT_BY_PROCESS_INSTANCE_START_TIME = "startTime";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private static final Map<String, String> ORDER_BY_VALUES;
    protected String processDefinitionId;
    protected String parentProcessDefinitionId;
    protected String[] activityIdIn;
    protected String[] activityInstanceIdIn;
    protected String businessKey;
    protected String parentProcessInstanceId;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Boolean withIncident;
    private List<VariableQueryParameterDto> variables;
    private List<QueryVariableValue> queryVariableValues;

    public AbstractProcessInstanceQueryDto() {
    }

    public AbstractProcessInstanceQueryDto(MultivaluedMap<String, String> queryParameter) {
        super(queryParameter);
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getParentProcessDefinitionId() {
        return this.parentProcessDefinitionId;
    }

    @CamundaQueryParam(value="parentProcessDefinitionId")
    public void setParentProcessDefinitionId(String parentProcessDefinitionId) {
        this.parentProcessDefinitionId = parentProcessDefinitionId;
    }

    @CamundaQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }

    public void initQueryVariableValues(VariableSerializers variableTypes, String dbType) {
        this.queryVariableValues = this.createQueryVariableValues(variableTypes, this.variables, dbType);
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    @CamundaQueryParam(value="parentProcessInstanceId")
    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public String[] getActivityIdIn() {
        return this.activityIdIn;
    }

    @CamundaQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public String[] getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    @CamundaQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    @CamundaQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    @CamundaQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    @CamundaQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    public Boolean getWithIncident() {
        return this.withIncident;
    }

    @CamundaQueryParam(value="withIncident", converter=BooleanConverter.class)
    public void setWithIncident(Boolean withIncident) {
        this.withIncident = withIncident;
    }

    protected String getOrderByValue(String sortBy) {
        return (String)ORDER_BY_VALUES.get(sortBy);
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    public String getOuterOrderBy() {
        String outerOrderBy = this.getOrderBy();
        if (outerOrderBy == null || outerOrderBy.isEmpty()) {
            return "ID_ asc";
        }
        if (outerOrderBy.contains(".")) {
            return outerOrderBy.substring(outerOrderBy.lastIndexOf(".") + 1);
        }
        return outerOrderBy;
    }

    private List<QueryVariableValue> createQueryVariableValues(VariableSerializers variableTypes, List<VariableQueryParameterDto> variables, String dbType) {
        ArrayList<QueryVariableValue> values = new ArrayList<QueryVariableValue>();
        if (variables == null) {
            return values;
        }
        for (VariableQueryParameterDto variable : variables) {
            QueryVariableValue value = new QueryVariableValue(variable.getName(), this.resolveVariableValue(variable.getValue()), ConditionQueryParameterDto.getQueryOperator((String)variable.getOperator()), false);
            value.initialize(variableTypes, dbType);
            values.add(value);
        }
        return values;
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_START_TIME);
        ORDER_BY_VALUES = new HashMap();
        ORDER_BY_VALUES.put(SORT_BY_PROCESS_INSTANCE_START_TIME, "START_TIME_");
    }
}

