/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.plugin.base.sub.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.cockpit.db.QueryParameters;
import org.camunda.bpm.cockpit.db.QueryService;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionDto;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.query.ProcessDefinitionQueryDto;
import org.camunda.bpm.cockpit.impl.plugin.base.sub.resources.ProcessDefinitionResource;
import org.camunda.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;

public class ProcessDefinitionResource
extends AbstractPluginResource {
    protected String id;

    public ProcessDefinitionResource(String engineName, String id) {
        super(engineName);
        this.id = id;
    }

    @GET
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    public List<ProcessDefinitionDto> getCalledProcessDefinitions(@Context UriInfo uriInfo) {
        ProcessDefinitionQueryDto queryParameter = new ProcessDefinitionQueryDto(uriInfo.getQueryParameters());
        return this.queryCalledProcessDefinitions(queryParameter);
    }

    @POST
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessDefinitionDto> queryCalledProcessDefinitions(ProcessDefinitionQueryDto queryParameter) {
        return (List)this.getCommandExecutor().executeCommand((Command)new QueryCalledProcessDefinitionsCmd(this, queryParameter));
    }

    private void injectEngineConfig(ProcessDefinitionQueryDto parameter) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)this.getProcessEngine()).getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            parameter.setHistoryEnabled(false);
        }
        parameter.initQueryVariableValues(processEngineConfiguration.getVariableSerializers(), processEngineConfiguration.getDatabaseType());
    }

    protected void configureExecutionQuery(ProcessDefinitionQueryDto query) {
        this.configureAuthorizationCheck((QueryParameters)query);
        this.configureTenantCheck((QueryParameters)query);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_INSTANCE, "EXEC2.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", (Permission)Permissions.READ_INSTANCE);
    }

    static /* synthetic */ void access$000(ProcessDefinitionResource x0, ProcessDefinitionQueryDto x1) {
        x0.injectEngineConfig(x1);
    }

    static /* synthetic */ QueryService access$100(ProcessDefinitionResource x0) {
        return x0.getQueryService();
    }
}

