/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.plugin.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.cockpit.db.QueryParameters;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.IncidentDto;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.query.IncidentQueryDto;
import org.camunda.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.rest.dto.CountResultDto;

@Produces(value={"application/json"})
public class IncidentRestService
extends AbstractPluginResource {
    public static final String PATH = "/incident";

    public IncidentRestService(String engineName) {
        super(engineName);
    }

    @GET
    @Produces(value={"application/json"})
    public List<IncidentDto> getIncidents(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        IncidentQueryDto queryParameter = new IncidentQueryDto(uriInfo.getQueryParameters());
        return this.queryIncidents(queryParameter, firstResult, maxResults);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<IncidentDto> queryIncidents(IncidentQueryDto queryParameter, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        this.paginateQueryParameters(queryParameter, firstResult, maxResults);
        this.configureExecutionQuery(queryParameter);
        List matchingIncidents = this.getQueryService().executeQuery("selectIncidentWithCauseAndRootCauseIncidents", (QueryParameters)queryParameter);
        return matchingIncidents;
    }

    private void paginateQueryParameters(IncidentQueryDto queryParameter, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        queryParameter.setFirstResult(firstResult.intValue());
        queryParameter.setMaxResults(maxResults.intValue());
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public CountResultDto getIncidentsCount(@Context UriInfo uriInfo) {
        IncidentQueryDto queryParameter = new IncidentQueryDto(uriInfo.getQueryParameters());
        return this.queryIncidentsCount(queryParameter);
    }

    @POST
    @Path(value="/count")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CountResultDto queryIncidentsCount(IncidentQueryDto queryParameter) {
        CountResultDto result = new CountResultDto();
        this.configureExecutionQuery(queryParameter);
        long count = this.getQueryService().executeQueryRowCount("selectIncidentWithCauseAndRootCauseIncidentsCount", (ListQueryParameterObject)queryParameter);
        result.setCount(count);
        return result;
    }

    protected void configureExecutionQuery(IncidentQueryDto query) {
        this.configureAuthorizationCheck((QueryParameters)query);
        this.configureTenantCheck((QueryParameters)query);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", (Permission)Permissions.READ_INSTANCE);
    }
}

