/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.plugin.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.cockpit.db.QueryParameters;
import org.camunda.bpm.cockpit.db.QueryService;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.ProcessInstanceDto;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.query.ProcessInstanceQueryDto;
import org.camunda.bpm.cockpit.impl.plugin.base.sub.resources.ProcessInstanceResource;
import org.camunda.bpm.cockpit.impl.plugin.resources.ProcessInstanceRestService;
import org.camunda.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.rest.dto.CountResultDto;

public class ProcessInstanceRestService
extends AbstractPluginResource {
    public static final String PATH = "/process-instance";
    protected ObjectMapper objectMapper;

    public ProcessInstanceRestService(String engineName) {
        super(engineName);
    }

    @Path(value="/{id}")
    public ProcessInstanceResource getProcessInstance(@PathParam(value="id") String id) {
        return new ProcessInstanceResource(this.getProcessEngine().getName(), id);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ProcessInstanceDto> getProcessInstances(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        ProcessInstanceQueryDto queryParameter = new ProcessInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryProcessInstances(queryParameter, firstResult, maxResults);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessInstanceDto> queryProcessInstances(ProcessInstanceQueryDto queryParameter, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        return (List)this.getCommandExecutor().executeCommand((Command)new QueryProcessInstancesCmd(this, queryParameter, firstResult, maxResults));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/count")
    public CountResultDto getProcessInstancesCount(@Context UriInfo uriInfo) {
        ProcessInstanceQueryDto queryParameter = new ProcessInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryProcessInstancesCount(queryParameter);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/count")
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto queryParameter) {
        return (CountResultDto)this.getCommandExecutor().executeCommand((Command)new QueryProcessInstancesCountCmd(this, queryParameter));
    }

    private void paginate(ProcessInstanceQueryDto queryParameter, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        queryParameter.setFirstResult(firstResult.intValue());
        queryParameter.setMaxResults(maxResults.intValue());
    }

    private void injectEngineConfig(ProcessInstanceQueryDto parameter) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)this.getProcessEngine()).getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            parameter.setHistoryEnabled(false);
        }
        parameter.initQueryVariableValues(processEngineConfiguration.getVariableSerializers(), processEngineConfiguration.getDatabaseType());
    }

    protected void configureExecutionQuery(ProcessInstanceQueryDto query) {
        this.configureAuthorizationCheck((QueryParameters)query);
        this.configureTenantCheck((QueryParameters)query);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_DEFINITION, "P.KEY_", (Permission)Permissions.READ_INSTANCE);
    }

    protected void injectObjectMapper(ProcessInstanceQueryDto queryParameter) {
        queryParameter.setObjectMapper(this.objectMapper);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    static /* synthetic */ void access$000(ProcessInstanceRestService x0, ProcessInstanceQueryDto x1) {
        x0.injectEngineConfig(x1);
    }

    static /* synthetic */ void access$100(ProcessInstanceRestService x0, ProcessInstanceQueryDto x1, Integer x2, Integer x3) {
        x0.paginate(x1, x2, x3);
    }

    static /* synthetic */ QueryService access$200(ProcessInstanceRestService x0) {
        return x0.getQueryService();
    }

    static /* synthetic */ QueryService access$300(ProcessInstanceRestService x0) {
        return x0.getQueryService();
    }
}

