/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.auth;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.camunda.bpm.webapp.impl.IllegalWebAppConfigurationException;
import org.camunda.bpm.webapp.impl.security.SecurityActions;
import org.camunda.bpm.webapp.impl.security.auth.AuthenticationUtil;
import org.camunda.bpm.webapp.impl.security.auth.Authentications;
import org.camunda.bpm.webapp.impl.util.ServletContextUtil;
import org.camunda.bpm.webapp.impl.util.ServletFilterUtil;

public class AuthenticationFilter
implements Filter {
    public static final String AUTH_CACHE_TTL_INIT_PARAM_NAME = "cacheTimeToLive";
    protected Long cacheTimeToLive = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        String authCacheTTLAsString = filterConfig.getInitParameter(AUTH_CACHE_TTL_INIT_PARAM_NAME);
        if (!ServletFilterUtil.isEmpty((String)authCacheTTLAsString)) {
            this.cacheTimeToLive = Long.parseLong(authCacheTTLAsString.trim());
            if (this.cacheTimeToLive < 0L) {
                throw new IllegalWebAppConfigurationException("'cacheTimeToLive' cannot be negative.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpSession session = req.getSession(true);
        Authentications authentications = AuthenticationUtil.getAuthsFromSession((HttpSession)session);
        if (this.cacheTimeToLive != null) {
            if (this.cacheTimeToLive > 0L) {
                ServletContext servletContext = request.getServletContext();
                ServletContextUtil.setCacheTTLForLogin((long)this.cacheTimeToLive, (ServletContext)servletContext);
            }
            AuthenticationUtil.updateCache((Authentications)authentications, (HttpSession)session, (long)this.cacheTimeToLive);
        }
        Authentications.setCurrent((Authentications)authentications);
        try {
            SecurityActions.runWithAuthentications(() -> {
                chain.doFilter(request, response);
                return null;
            }, (Authentications)authentications);
        }
        finally {
            Authentications.clearCurrent();
            AuthenticationUtil.updateSession((HttpSession)req.getSession(false), (Authentications)authentications);
        }
    }

    public void destroy() {
    }

    public Long getCacheTimeToLive() {
        return this.cacheTimeToLive;
    }
}

