/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.filter.headersec;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.camunda.bpm.webapp.impl.security.filter.headersec.provider.HeaderSecurityProvider;

public class HttpHeaderSecurityFilter
implements Filter {
    protected final List<HeaderSecurityProvider> headerSecurityProviders = new /* Unavailable Anonymous Inner Class!! */;

    public void init(FilterConfig filterConfig) {
        for (HeaderSecurityProvider provider : this.headerSecurityProviders) {
            Map filterParams = provider.initParams();
            for (Map.Entry entry : filterParams.entrySet()) {
                String key = (String)entry.getKey();
                String value = filterConfig.getInitParameter(key);
                if (value == null) continue;
                entry.setValue(value);
            }
            provider.parseParams();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            for (HeaderSecurityProvider provider : this.headerSecurityProviders) {
                if (provider.isDisabled()) continue;
                String headerName = provider.getHeaderName();
                String headerValue = provider.getHeaderValue(request.getServletContext());
                httpResponse.setHeader(headerName, headerValue);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

