/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DecisionDefinitionDiagramDto;
import org.camunda.community.rest.client.dto.DecisionDefinitionDto;
import org.camunda.community.rest.client.dto.EvaluateDecisionDto;
import org.camunda.community.rest.client.dto.HistoryTimeToLiveDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class DecisionDefinitionApi {
    private ApiClient localVarApiClient;

    public DecisionDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DecisionDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call evaluateDecisionByIdCall(String id, EvaluateDecisionDto evaluateDecisionDto, ApiCallback _callback) throws ApiException {
        EvaluateDecisionDto localVarPostBody = evaluateDecisionDto;
        String localVarPath = "/decision-definition/{id}/evaluate".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call evaluateDecisionByIdValidateBeforeCall(String id, EvaluateDecisionDto evaluateDecisionDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling evaluateDecisionById(Async)");
        }
        Call localVarCall = this.evaluateDecisionByIdCall(id, evaluateDecisionDto, _callback);
        return localVarCall;
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionById(String id, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        ApiResponse<List<Map<String, VariableValueDto>>> localVarResp = this.evaluateDecisionByIdWithHttpInfo(id, evaluateDecisionDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<Map<String, VariableValueDto>>> evaluateDecisionByIdWithHttpInfo(String id, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        Call localVarCall = this.evaluateDecisionByIdValidateBeforeCall(id, evaluateDecisionDto, null);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call evaluateDecisionByIdAsync(String id, EvaluateDecisionDto evaluateDecisionDto, ApiCallback<List<Map<String, VariableValueDto>>> _callback) throws ApiException {
        Call localVarCall = this.evaluateDecisionByIdValidateBeforeCall(id, evaluateDecisionDto, _callback);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call evaluateDecisionByKeyCall(String key, EvaluateDecisionDto evaluateDecisionDto, ApiCallback _callback) throws ApiException {
        EvaluateDecisionDto localVarPostBody = evaluateDecisionDto;
        String localVarPath = "/decision-definition/key/{key}/evaluate".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call evaluateDecisionByKeyValidateBeforeCall(String key, EvaluateDecisionDto evaluateDecisionDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling evaluateDecisionByKey(Async)");
        }
        Call localVarCall = this.evaluateDecisionByKeyCall(key, evaluateDecisionDto, _callback);
        return localVarCall;
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionByKey(String key, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        ApiResponse<List<Map<String, VariableValueDto>>> localVarResp = this.evaluateDecisionByKeyWithHttpInfo(key, evaluateDecisionDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<Map<String, VariableValueDto>>> evaluateDecisionByKeyWithHttpInfo(String key, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        Call localVarCall = this.evaluateDecisionByKeyValidateBeforeCall(key, evaluateDecisionDto, null);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call evaluateDecisionByKeyAsync(String key, EvaluateDecisionDto evaluateDecisionDto, ApiCallback<List<Map<String, VariableValueDto>>> _callback) throws ApiException {
        Call localVarCall = this.evaluateDecisionByKeyValidateBeforeCall(key, evaluateDecisionDto, _callback);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call evaluateDecisionByKeyAndTenantCall(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto, ApiCallback _callback) throws ApiException {
        EvaluateDecisionDto localVarPostBody = evaluateDecisionDto;
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/evaluate".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call evaluateDecisionByKeyAndTenantValidateBeforeCall(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling evaluateDecisionByKeyAndTenant(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling evaluateDecisionByKeyAndTenant(Async)");
        }
        Call localVarCall = this.evaluateDecisionByKeyAndTenantCall(key, tenantId, evaluateDecisionDto, _callback);
        return localVarCall;
    }

    public List<Map<String, VariableValueDto>> evaluateDecisionByKeyAndTenant(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        ApiResponse<List<Map<String, VariableValueDto>>> localVarResp = this.evaluateDecisionByKeyAndTenantWithHttpInfo(key, tenantId, evaluateDecisionDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<Map<String, VariableValueDto>>> evaluateDecisionByKeyAndTenantWithHttpInfo(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        Call localVarCall = this.evaluateDecisionByKeyAndTenantValidateBeforeCall(key, tenantId, evaluateDecisionDto, null);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call evaluateDecisionByKeyAndTenantAsync(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto, ApiCallback<List<Map<String, VariableValueDto>>> _callback) throws ApiException {
        Call localVarCall = this.evaluateDecisionByKeyAndTenantValidateBeforeCall(key, tenantId, evaluateDecisionDto, _callback);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionByIdCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionByIdValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionDefinitionById(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionByIdCall(id, _callback);
        return localVarCall;
    }

    public DecisionDefinitionDto getDecisionDefinitionById(String id) throws ApiException {
        ApiResponse<DecisionDefinitionDto> localVarResp = this.getDecisionDefinitionByIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<DecisionDefinitionDto> getDecisionDefinitionByIdWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionByIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionByIdAsync(String id, ApiCallback<DecisionDefinitionDto> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/key/{key}".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionByKey(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionByKeyCall(key, _callback);
        return localVarCall;
    }

    public DecisionDefinitionDto getDecisionDefinitionByKey(String key) throws ApiException {
        ApiResponse<DecisionDefinitionDto> localVarResp = this.getDecisionDefinitionByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<DecisionDefinitionDto> getDecisionDefinitionByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionByKeyAsync(String key, ApiCallback<DecisionDefinitionDto> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionByKeyAndTenantIdCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionDefinitionByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;
    }

    public DecisionDefinitionDto getDecisionDefinitionByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<DecisionDefinitionDto> localVarResp = this.getDecisionDefinitionByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<DecisionDefinitionDto> getDecisionDefinitionByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionByKeyAndTenantIdAsync(String key, String tenantId, ApiCallback<DecisionDefinitionDto> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionDiagramCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/{id}/diagram".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionDiagramValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionDefinitionDiagram(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionDiagramCall(id, _callback);
        return localVarCall;
    }

    public File getDecisionDefinitionDiagram(String id) throws ApiException {
        ApiResponse<File> localVarResp = this.getDecisionDefinitionDiagramWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDecisionDefinitionDiagramWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDiagramValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionDiagramAsync(String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDiagramValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionDiagramByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/key/{key}/diagram".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionDiagramByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionDiagramByKey(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionDiagramByKeyCall(key, _callback);
        return localVarCall;
    }

    public File getDecisionDefinitionDiagramByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = this.getDecisionDefinitionDiagramByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDecisionDefinitionDiagramByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDiagramByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionDiagramByKeyAsync(String key, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDiagramByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionDiagramByKeyAndTenantCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/diagram".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionDiagramByKeyAndTenantValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionDiagramByKeyAndTenant(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionDefinitionDiagramByKeyAndTenant(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionDiagramByKeyAndTenantCall(key, tenantId, _callback);
        return localVarCall;
    }

    public File getDecisionDefinitionDiagramByKeyAndTenant(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = this.getDecisionDefinitionDiagramByKeyAndTenantWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDecisionDefinitionDiagramByKeyAndTenantWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDiagramByKeyAndTenantValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionDiagramByKeyAndTenantAsync(String key, String tenantId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDiagramByKeyAndTenantValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionDmnXmlByIdCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/{id}/xml".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionDmnXmlByIdValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionDefinitionDmnXmlById(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionDmnXmlByIdCall(id, _callback);
        return localVarCall;
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlById(String id) throws ApiException {
        ApiResponse<DecisionDefinitionDiagramDto> localVarResp = this.getDecisionDefinitionDmnXmlByIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<DecisionDefinitionDiagramDto> getDecisionDefinitionDmnXmlByIdWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDmnXmlByIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionDmnXmlByIdAsync(String id, ApiCallback<DecisionDefinitionDiagramDto> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDmnXmlByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionDmnXmlByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/key/{key}/xml".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionDmnXmlByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionDmnXmlByKey(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionDmnXmlByKeyCall(key, _callback);
        return localVarCall;
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKey(String key) throws ApiException {
        ApiResponse<DecisionDefinitionDiagramDto> localVarResp = this.getDecisionDefinitionDmnXmlByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<DecisionDefinitionDiagramDto> getDecisionDefinitionDmnXmlByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDmnXmlByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionDmnXmlByKeyAsync(String key, ApiCallback<DecisionDefinitionDiagramDto> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDmnXmlByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionDmnXmlByKeyAndTenantCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/xml".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionDmnXmlByKeyAndTenantValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionDmnXmlByKeyAndTenant(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionDefinitionDmnXmlByKeyAndTenant(Async)");
        }
        Call localVarCall = this.getDecisionDefinitionDmnXmlByKeyAndTenantCall(key, tenantId, _callback);
        return localVarCall;
    }

    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKeyAndTenant(String key, String tenantId) throws ApiException {
        ApiResponse<DecisionDefinitionDiagramDto> localVarResp = this.getDecisionDefinitionDmnXmlByKeyAndTenantWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<DecisionDefinitionDiagramDto> getDecisionDefinitionDmnXmlByKeyAndTenantWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDmnXmlByKeyAndTenantValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionDmnXmlByKeyAndTenantAsync(String key, String tenantId, ApiCallback<DecisionDefinitionDiagramDto> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionDmnXmlByKeyAndTenantValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionsCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if (decisionDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
        }
        if (decisionDefinitionIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (deploymentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }
        if (deployedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployedAfter", deployedAfter));
        }
        if (deployedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployedAt", deployedAt));
        }
        if (key != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("key", key));
        }
        if (keyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keyLike", keyLike));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category", category));
        }
        if (categoryLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (latestVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }
        if (resourceName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceName", resourceName));
        }
        if (resourceNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }
        if (decisionRequirementsDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        }
        if (decisionRequirementsDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
        }
        if (withoutDecisionRequirementsDefinition != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutDecisionRequirementsDefinition", withoutDecisionRequirementsDefinition));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeDecisionDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeDecisionDefinitionsWithoutTenantId", includeDecisionDefinitionsWithoutTenantId));
        }
        if (versionTag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionTag", versionTag));
        }
        if (versionTagLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionTagLike", versionTagLike));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionsValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionsCall(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, _callback);
        return localVarCall;
    }

    public List<DecisionDefinitionDto> getDecisionDefinitions(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        ApiResponse<List<DecisionDefinitionDto>> localVarResp = this.getDecisionDefinitionsWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike);
        return localVarResp.getData();
    }

    public ApiResponse<List<DecisionDefinitionDto>> getDecisionDefinitionsWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, null);
        Type localVarReturnType = new TypeToken<List<DecisionDefinitionDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionsAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, ApiCallback<List<DecisionDefinitionDto>> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, _callback);
        Type localVarReturnType = new TypeToken<List<DecisionDefinitionDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDecisionDefinitionsCountCall(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/decision-definition/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (decisionDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
        }
        if (decisionDefinitionIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (deploymentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }
        if (deployedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployedAfter", deployedAfter));
        }
        if (deployedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployedAt", deployedAt));
        }
        if (key != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("key", key));
        }
        if (keyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keyLike", keyLike));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category", category));
        }
        if (categoryLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (latestVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }
        if (resourceName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceName", resourceName));
        }
        if (resourceNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }
        if (decisionRequirementsDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        }
        if (decisionRequirementsDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
        }
        if (withoutDecisionRequirementsDefinition != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutDecisionRequirementsDefinition", withoutDecisionRequirementsDefinition));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeDecisionDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeDecisionDefinitionsWithoutTenantId", includeDecisionDefinitionsWithoutTenantId));
        }
        if (versionTag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionTag", versionTag));
        }
        if (versionTagLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionTagLike", versionTagLike));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDecisionDefinitionsCountValidateBeforeCall(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionsCountCall(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, _callback);
        return localVarCall;
    }

    public CountResultDto getDecisionDefinitionsCount(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getDecisionDefinitionsCountWithHttpInfo(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getDecisionDefinitionsCountWithHttpInfo(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionsCountValidateBeforeCall(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDecisionDefinitionsCountAsync(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getDecisionDefinitionsCountValidateBeforeCall(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateHistoryTimeToLiveByDecisionDefinitionIdCall(String id, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        String localVarPath = "/decision-definition/{id}/history-time-to-live".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateHistoryTimeToLiveByDecisionDefinitionIdValidateBeforeCall(String id, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateHistoryTimeToLiveByDecisionDefinitionId(Async)");
        }
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionIdCall(id, historyTimeToLiveDto, _callback);
        return localVarCall;
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByDecisionDefinitionIdWithHttpInfo(id, historyTimeToLiveDto);
    }

    public ApiResponse<Void> updateHistoryTimeToLiveByDecisionDefinitionIdWithHttpInfo(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionIdValidateBeforeCall(id, historyTimeToLiveDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateHistoryTimeToLiveByDecisionDefinitionIdAsync(String id, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionIdValidateBeforeCall(id, historyTimeToLiveDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateHistoryTimeToLiveByDecisionDefinitionKeyCall(String key, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        String localVarPath = "/decision-definition/key/{key}/history-time-to-live".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateHistoryTimeToLiveByDecisionDefinitionKeyValidateBeforeCall(String key, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateHistoryTimeToLiveByDecisionDefinitionKey(Async)");
        }
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionKeyCall(key, historyTimeToLiveDto, _callback);
        return localVarCall;
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByDecisionDefinitionKeyWithHttpInfo(key, historyTimeToLiveDto);
    }

    public ApiResponse<Void> updateHistoryTimeToLiveByDecisionDefinitionKeyWithHttpInfo(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionKeyValidateBeforeCall(key, historyTimeToLiveDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateHistoryTimeToLiveByDecisionDefinitionKeyAsync(String key, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionKeyValidateBeforeCall(key, historyTimeToLiveDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantCall(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantValidateBeforeCall(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(Async)");
        }
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantCall(key, tenantId, historyTimeToLiveDto, _callback);
        return localVarCall;
    }

    public void updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantWithHttpInfo(key, tenantId, historyTimeToLiveDto);
    }

    public ApiResponse<Void> updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantWithHttpInfo(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantValidateBeforeCall(key, tenantId, historyTimeToLiveDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantAsync(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantValidateBeforeCall(key, tenantId, historyTimeToLiveDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

