/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CleanableHistoricBatchReportResultDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.HistoricBatchDto;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricBatchesDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class HistoricBatchApi {
    private ApiClient localVarApiClient;

    public HistoricBatchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricBatchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteHistoricBatchCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/batch/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteHistoricBatchValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteHistoricBatch(Async)");
        }
        Call localVarCall = this.deleteHistoricBatchCall(id, _callback);
        return localVarCall;
    }

    public void deleteHistoricBatch(String id) throws ApiException {
        this.deleteHistoricBatchWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteHistoricBatchWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteHistoricBatchValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteHistoricBatchAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteHistoricBatchValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getCleanableHistoricBatchesReportCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/history/batch/cleanable-batch-report";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCleanableHistoricBatchesReportValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getCleanableHistoricBatchesReportCall(sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<CleanableHistoricBatchReportResultDto> getCleanableHistoricBatchesReport(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<CleanableHistoricBatchReportResultDto>> localVarResp = this.getCleanableHistoricBatchesReportWithHttpInfo(sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<CleanableHistoricBatchReportResultDto>> getCleanableHistoricBatchesReportWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getCleanableHistoricBatchesReportValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<CleanableHistoricBatchReportResultDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCleanableHistoricBatchesReportAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<CleanableHistoricBatchReportResultDto>> _callback) throws ApiException {
        Call localVarCall = this.getCleanableHistoricBatchesReportValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<CleanableHistoricBatchReportResultDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCleanableHistoricBatchesReportCountCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/history/batch/cleanable-batch-report/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCleanableHistoricBatchesReportCountValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getCleanableHistoricBatchesReportCountCall(sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public CountResultDto getCleanableHistoricBatchesReportCount(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getCleanableHistoricBatchesReportCountWithHttpInfo(sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getCleanableHistoricBatchesReportCountWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getCleanableHistoricBatchesReportCountValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCleanableHistoricBatchesReportCountAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getCleanableHistoricBatchesReportCountValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHistoricBatchCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/batch/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHistoricBatchValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricBatch(Async)");
        }
        Call localVarCall = this.getHistoricBatchCall(id, _callback);
        return localVarCall;
    }

    public HistoricBatchDto getHistoricBatch(String id) throws ApiException {
        ApiResponse<HistoricBatchDto> localVarResp = this.getHistoricBatchWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<HistoricBatchDto> getHistoricBatchWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getHistoricBatchValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<HistoricBatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHistoricBatchAsync(String id, ApiCallback<HistoricBatchDto> _callback) throws ApiException {
        Call localVarCall = this.getHistoricBatchValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<HistoricBatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHistoricBatchesCall(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/history/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (batchId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("batchId", batchId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (completed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("completed", completed));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHistoricBatchesValidateBeforeCall(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getHistoricBatchesCall(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<HistoricBatchDto> getHistoricBatches(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<HistoricBatchDto>> localVarResp = this.getHistoricBatchesWithHttpInfo(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<HistoricBatchDto>> getHistoricBatchesWithHttpInfo(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getHistoricBatchesValidateBeforeCall(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<HistoricBatchDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHistoricBatchesAsync(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<HistoricBatchDto>> _callback) throws ApiException {
        Call localVarCall = this.getHistoricBatchesValidateBeforeCall(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricBatchDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHistoricBatchesCountCall(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/history/batch/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (batchId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("batchId", batchId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (completed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("completed", completed));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHistoricBatchesCountValidateBeforeCall(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getHistoricBatchesCountCall(batchId, type, completed, tenantIdIn, withoutTenantId, _callback);
        return localVarCall;
    }

    public CountResultDto getHistoricBatchesCount(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getHistoricBatchesCountWithHttpInfo(batchId, type, completed, tenantIdIn, withoutTenantId);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getHistoricBatchesCountWithHttpInfo(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        Call localVarCall = this.getHistoricBatchesCountValidateBeforeCall(batchId, type, completed, tenantIdIn, withoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHistoricBatchesCountAsync(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getHistoricBatchesCountValidateBeforeCall(batchId, type, completed, tenantIdIn, withoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setRemovalTimeAsyncHistoricBatchCall(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto, ApiCallback _callback) throws ApiException {
        SetRemovalTimeToHistoricBatchesDto localVarPostBody = setRemovalTimeToHistoricBatchesDto;
        String localVarPath = "/history/batch/set-removal-time";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setRemovalTimeAsyncHistoricBatchValidateBeforeCall(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.setRemovalTimeAsyncHistoricBatchCall(setRemovalTimeToHistoricBatchesDto, _callback);
        return localVarCall;
    }

    public BatchDto setRemovalTimeAsyncHistoricBatch(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.setRemovalTimeAsyncHistoricBatchWithHttpInfo(setRemovalTimeToHistoricBatchesDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> setRemovalTimeAsyncHistoricBatchWithHttpInfo(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto) throws ApiException {
        Call localVarCall = this.setRemovalTimeAsyncHistoricBatchValidateBeforeCall(setRemovalTimeToHistoricBatchesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setRemovalTimeAsyncHistoricBatchAsync(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.setRemovalTimeAsyncHistoricBatchValidateBeforeCall(setRemovalTimeToHistoricBatchesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

