/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DeleteHistoricProcessInstancesDto;
import org.camunda.community.rest.client.dto.DurationReportResultDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricProcessInstancesDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class HistoricProcessInstanceApi {
    private ApiClient localVarApiClient;

    public HistoricProcessInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricProcessInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteHistoricProcessInstanceCall(String id, Boolean failIfNotExists, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/history/process-instance/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (failIfNotExists != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failIfNotExists", failIfNotExists));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteHistoricProcessInstanceValidateBeforeCall(String id, Boolean failIfNotExists, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteHistoricProcessInstance(Async)");
        }
        Call localVarCall = this.deleteHistoricProcessInstanceCall(id, failIfNotExists, _callback);
        return localVarCall;
    }

    public void deleteHistoricProcessInstance(String id, Boolean failIfNotExists) throws ApiException {
        this.deleteHistoricProcessInstanceWithHttpInfo(id, failIfNotExists);
    }

    public ApiResponse<Void> deleteHistoricProcessInstanceWithHttpInfo(String id, Boolean failIfNotExists) throws ApiException {
        Call localVarCall = this.deleteHistoricProcessInstanceValidateBeforeCall(id, failIfNotExists, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteHistoricProcessInstanceAsync(String id, Boolean failIfNotExists, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteHistoricProcessInstanceValidateBeforeCall(id, failIfNotExists, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteHistoricProcessInstancesAsyncCall(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto, ApiCallback _callback) throws ApiException {
        DeleteHistoricProcessInstancesDto localVarPostBody = deleteHistoricProcessInstancesDto;
        String localVarPath = "/history/process-instance/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteHistoricProcessInstancesAsyncValidateBeforeCall(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteHistoricProcessInstancesAsyncCall(deleteHistoricProcessInstancesDto, _callback);
        return localVarCall;
    }

    public BatchDto deleteHistoricProcessInstancesAsync(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.deleteHistoricProcessInstancesAsyncWithHttpInfo(deleteHistoricProcessInstancesDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> deleteHistoricProcessInstancesAsyncWithHttpInfo(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto) throws ApiException {
        Call localVarCall = this.deleteHistoricProcessInstancesAsyncValidateBeforeCall(deleteHistoricProcessInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteHistoricProcessInstancesAsyncAsync(DeleteHistoricProcessInstancesDto deleteHistoricProcessInstancesDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.deleteHistoricProcessInstancesAsyncValidateBeforeCall(deleteHistoricProcessInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteHistoricVariableInstancesOfHistoricProcessInstanceCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/process-instance/{id}/variable-instances".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteHistoricVariableInstancesOfHistoricProcessInstanceValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteHistoricVariableInstancesOfHistoricProcessInstance(Async)");
        }
        Call localVarCall = this.deleteHistoricVariableInstancesOfHistoricProcessInstanceCall(id, _callback);
        return localVarCall;
    }

    public void deleteHistoricVariableInstancesOfHistoricProcessInstance(String id) throws ApiException {
        this.deleteHistoricVariableInstancesOfHistoricProcessInstanceWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteHistoricVariableInstancesOfHistoricProcessInstanceWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteHistoricVariableInstancesOfHistoricProcessInstanceValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteHistoricVariableInstancesOfHistoricProcessInstanceAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteHistoricVariableInstancesOfHistoricProcessInstanceValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getHistoricProcessInstanceCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/process-instance/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHistoricProcessInstanceValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricProcessInstance(Async)");
        }
        Call localVarCall = this.getHistoricProcessInstanceCall(id, _callback);
        return localVarCall;
    }

    public HistoricProcessInstanceDto getHistoricProcessInstance(String id) throws ApiException {
        ApiResponse<HistoricProcessInstanceDto> localVarResp = this.getHistoricProcessInstanceWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<HistoricProcessInstanceDto> getHistoricProcessInstanceWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstanceValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<HistoricProcessInstanceDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHistoricProcessInstanceAsync(String id, ApiCallback<HistoricProcessInstanceDto> _callback) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstanceValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<HistoricProcessInstanceDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHistoricProcessInstanceDurationReportCall(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/history/process-instance/report";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (reportType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reportType", reportType));
        }
        if (periodUnit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("periodUnit", periodUnit));
        }
        if (processDefinitionIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (startedBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }
        if (startedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/csv", "text/csv"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHistoricProcessInstanceDurationReportValidateBeforeCall(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter, ApiCallback _callback) throws ApiException {
        if (reportType == null) {
            throw new ApiException("Missing the required parameter 'reportType' when calling getHistoricProcessInstanceDurationReport(Async)");
        }
        if (periodUnit == null) {
            throw new ApiException("Missing the required parameter 'periodUnit' when calling getHistoricProcessInstanceDurationReport(Async)");
        }
        Call localVarCall = this.getHistoricProcessInstanceDurationReportCall(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter, _callback);
        return localVarCall;
    }

    public List<DurationReportResultDto> getHistoricProcessInstanceDurationReport(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter) throws ApiException {
        ApiResponse<List<DurationReportResultDto>> localVarResp = this.getHistoricProcessInstanceDurationReportWithHttpInfo(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter);
        return localVarResp.getData();
    }

    public ApiResponse<List<DurationReportResultDto>> getHistoricProcessInstanceDurationReportWithHttpInfo(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstanceDurationReportValidateBeforeCall(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter, null);
        Type localVarReturnType = new TypeToken<List<DurationReportResultDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHistoricProcessInstanceDurationReportAsync(String reportType, String periodUnit, String processDefinitionIdIn, String processDefinitionKeyIn, Date startedBefore, Date startedAfter, ApiCallback<List<DurationReportResultDto>> _callback) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstanceDurationReportValidateBeforeCall(reportType, periodUnit, processDefinitionIdIn, processDefinitionKeyIn, startedBefore, startedAfter, _callback);
        Type localVarReturnType = new TypeToken<List<DurationReportResultDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHistoricProcessInstancesCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/history/process-instance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (processInstanceIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (processDefinitionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionName", processDefinitionName));
        }
        if (processDefinitionNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        }
        if (processDefinitionKeyNotIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        }
        if (processInstanceBusinessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        }
        if (processInstanceBusinessKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        }
        if (processInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        }
        if (rootProcessInstances != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        }
        if (finished != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("finished", finished));
        }
        if (unfinished != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unfinished", unfinished));
        }
        if (withIncidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withIncidents", withIncidents));
        }
        if (withRootIncidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withRootIncidents", withRootIncidents));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentStatus", incidentStatus));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (startedBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }
        if (startedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }
        if (finishedBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("finishedBefore", finishedBefore));
        }
        if (finishedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("finishedAfter", finishedAfter));
        }
        if (executedActivityAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedActivityAfter", executedActivityAfter));
        }
        if (executedActivityBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedActivityBefore", executedActivityBefore));
        }
        if (executedJobAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedJobAfter", executedJobAfter));
        }
        if (executedJobBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedJobBefore", executedJobBefore));
        }
        if (startedBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startedBy", startedBy));
        }
        if (superProcessInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("superProcessInstanceId", superProcessInstanceId));
        }
        if (subProcessInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subProcessInstanceId", subProcessInstanceId));
        }
        if (superCaseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("superCaseInstanceId", superCaseInstanceId));
        }
        if (subCaseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subCaseInstanceId", subCaseInstanceId));
        }
        if (caseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (executedActivityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedActivityIdIn", executedActivityIdIn));
        }
        if (activeActivityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activeActivityIdIn", activeActivityIdIn));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (completed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("completed", completed));
        }
        if (externallyTerminated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("externallyTerminated", externallyTerminated));
        }
        if (internallyTerminated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("internallyTerminated", internallyTerminated));
        }
        if (variables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variables", variables));
        }
        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }
        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHistoricProcessInstancesValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstancesCall(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;
    }

    public List<HistoricProcessInstanceDto> getHistoricProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<List<HistoricProcessInstanceDto>> localVarResp = this.getHistoricProcessInstancesWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    public ApiResponse<List<HistoricProcessInstanceDto>> getHistoricProcessInstancesWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<List<HistoricProcessInstanceDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHistoricProcessInstancesAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback<List<HistoricProcessInstanceDto>> _callback) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricProcessInstanceDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHistoricProcessInstancesCountCall(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/history/process-instance/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (processInstanceIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (processDefinitionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionName", processDefinitionName));
        }
        if (processDefinitionNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        }
        if (processDefinitionKeyNotIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        }
        if (processInstanceBusinessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        }
        if (processInstanceBusinessKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        }
        if (processInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        }
        if (rootProcessInstances != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        }
        if (finished != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("finished", finished));
        }
        if (unfinished != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unfinished", unfinished));
        }
        if (withIncidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withIncidents", withIncidents));
        }
        if (withRootIncidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withRootIncidents", withRootIncidents));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentStatus", incidentStatus));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (startedBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }
        if (startedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }
        if (finishedBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("finishedBefore", finishedBefore));
        }
        if (finishedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("finishedAfter", finishedAfter));
        }
        if (executedActivityAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedActivityAfter", executedActivityAfter));
        }
        if (executedActivityBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedActivityBefore", executedActivityBefore));
        }
        if (executedJobAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedJobAfter", executedJobAfter));
        }
        if (executedJobBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedJobBefore", executedJobBefore));
        }
        if (startedBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startedBy", startedBy));
        }
        if (superProcessInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("superProcessInstanceId", superProcessInstanceId));
        }
        if (subProcessInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subProcessInstanceId", subProcessInstanceId));
        }
        if (superCaseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("superCaseInstanceId", superCaseInstanceId));
        }
        if (subCaseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subCaseInstanceId", subCaseInstanceId));
        }
        if (caseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (executedActivityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executedActivityIdIn", executedActivityIdIn));
        }
        if (activeActivityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activeActivityIdIn", activeActivityIdIn));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (completed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("completed", completed));
        }
        if (externallyTerminated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("externallyTerminated", externallyTerminated));
        }
        if (internallyTerminated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("internallyTerminated", internallyTerminated));
        }
        if (variables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variables", variables));
        }
        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }
        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHistoricProcessInstancesCountValidateBeforeCall(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstancesCountCall(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;
    }

    public CountResultDto getHistoricProcessInstancesCount(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getHistoricProcessInstancesCountWithHttpInfo(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getHistoricProcessInstancesCountWithHttpInfo(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstancesCountValidateBeforeCall(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHistoricProcessInstancesCountAsync(String processInstanceId, String processInstanceIds, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String processDefinitionKeyNotIn, String processInstanceBusinessKey, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, Boolean rootProcessInstances, Boolean finished, Boolean unfinished, Boolean withIncidents, Boolean withRootIncidents, String incidentType, String incidentStatus, String incidentMessage, String incidentMessageLike, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, Date executedActivityAfter, Date executedActivityBefore, Date executedJobAfter, Date executedJobBefore, String startedBy, String superProcessInstanceId, String subProcessInstanceId, String superCaseInstanceId, String subCaseInstanceId, String caseInstanceId, String tenantIdIn, Boolean withoutTenantId, String executedActivityIdIn, String activeActivityIdIn, Boolean active, Boolean suspended, Boolean completed, Boolean externallyTerminated, Boolean internallyTerminated, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getHistoricProcessInstancesCountValidateBeforeCall(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryHistoricProcessInstancesCall(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        HistoricProcessInstanceQueryDto localVarPostBody = historicProcessInstanceQueryDto;
        String localVarPath = "/history/process-instance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryHistoricProcessInstancesValidateBeforeCall(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryHistoricProcessInstancesCall(firstResult, maxResults, historicProcessInstanceQueryDto, _callback);
        return localVarCall;
    }

    public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        ApiResponse<List<HistoricProcessInstanceDto>> localVarResp = this.queryHistoricProcessInstancesWithHttpInfo(firstResult, maxResults, historicProcessInstanceQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<HistoricProcessInstanceDto>> queryHistoricProcessInstancesWithHttpInfo(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        Call localVarCall = this.queryHistoricProcessInstancesValidateBeforeCall(firstResult, maxResults, historicProcessInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<List<HistoricProcessInstanceDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryHistoricProcessInstancesAsync(Integer firstResult, Integer maxResults, HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, ApiCallback<List<HistoricProcessInstanceDto>> _callback) throws ApiException {
        Call localVarCall = this.queryHistoricProcessInstancesValidateBeforeCall(firstResult, maxResults, historicProcessInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricProcessInstanceDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryHistoricProcessInstancesCountCall(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, ApiCallback _callback) throws ApiException {
        HistoricProcessInstanceQueryDto localVarPostBody = historicProcessInstanceQueryDto;
        String localVarPath = "/history/process-instance/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryHistoricProcessInstancesCountValidateBeforeCall(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryHistoricProcessInstancesCountCall(historicProcessInstanceQueryDto, _callback);
        return localVarCall;
    }

    public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.queryHistoricProcessInstancesCountWithHttpInfo(historicProcessInstanceQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> queryHistoricProcessInstancesCountWithHttpInfo(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto) throws ApiException {
        Call localVarCall = this.queryHistoricProcessInstancesCountValidateBeforeCall(historicProcessInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryHistoricProcessInstancesCountAsync(HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.queryHistoricProcessInstancesCountValidateBeforeCall(historicProcessInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setRemovalTimeAsyncCall(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto, ApiCallback _callback) throws ApiException {
        SetRemovalTimeToHistoricProcessInstancesDto localVarPostBody = setRemovalTimeToHistoricProcessInstancesDto;
        String localVarPath = "/history/process-instance/set-removal-time";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setRemovalTimeAsyncValidateBeforeCall(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.setRemovalTimeAsyncCall(setRemovalTimeToHistoricProcessInstancesDto, _callback);
        return localVarCall;
    }

    public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.setRemovalTimeAsyncWithHttpInfo(setRemovalTimeToHistoricProcessInstancesDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> setRemovalTimeAsyncWithHttpInfo(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto) throws ApiException {
        Call localVarCall = this.setRemovalTimeAsyncValidateBeforeCall(setRemovalTimeToHistoricProcessInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setRemovalTimeAsyncAsync(SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.setRemovalTimeAsyncValidateBeforeCall(setRemovalTimeToHistoricProcessInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

