/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CompleteTaskDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.FormDto;
import org.camunda.community.rest.client.dto.TaskBpmnErrorDto;
import org.camunda.community.rest.client.dto.TaskDto;
import org.camunda.community.rest.client.dto.TaskEscalationDto;
import org.camunda.community.rest.client.dto.TaskQueryDto;
import org.camunda.community.rest.client.dto.UserIdDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class TaskApi {
    private ApiClient localVarApiClient;

    public TaskApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call claimCall(String id, UserIdDto userIdDto, ApiCallback _callback) throws ApiException {
        UserIdDto localVarPostBody = userIdDto;
        String localVarPath = "/task/{id}/claim".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call claimValidateBeforeCall(String id, UserIdDto userIdDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling claim(Async)");
        }
        Call localVarCall = this.claimCall(id, userIdDto, _callback);
        return localVarCall;
    }

    public void claim(String id, UserIdDto userIdDto) throws ApiException {
        this.claimWithHttpInfo(id, userIdDto);
    }

    public ApiResponse<Void> claimWithHttpInfo(String id, UserIdDto userIdDto) throws ApiException {
        Call localVarCall = this.claimValidateBeforeCall(id, userIdDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call claimAsync(String id, UserIdDto userIdDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.claimValidateBeforeCall(id, userIdDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call completeCall(String id, CompleteTaskDto completeTaskDto, ApiCallback _callback) throws ApiException {
        CompleteTaskDto localVarPostBody = completeTaskDto;
        String localVarPath = "/task/{id}/complete".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call completeValidateBeforeCall(String id, CompleteTaskDto completeTaskDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling complete(Async)");
        }
        Call localVarCall = this.completeCall(id, completeTaskDto, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> complete(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.completeWithHttpInfo(id, completeTaskDto);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> completeWithHttpInfo(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        Call localVarCall = this.completeValidateBeforeCall(id, completeTaskDto, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call completeAsync(String id, CompleteTaskDto completeTaskDto, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.completeValidateBeforeCall(id, completeTaskDto, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createTaskCall(TaskDto taskDto, ApiCallback _callback) throws ApiException {
        TaskDto localVarPostBody = taskDto;
        String localVarPath = "/task/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTaskValidateBeforeCall(TaskDto taskDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createTaskCall(taskDto, _callback);
        return localVarCall;
    }

    public void createTask(TaskDto taskDto) throws ApiException {
        this.createTaskWithHttpInfo(taskDto);
    }

    public ApiResponse<Void> createTaskWithHttpInfo(TaskDto taskDto) throws ApiException {
        Call localVarCall = this.createTaskValidateBeforeCall(taskDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createTaskAsync(TaskDto taskDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createTaskValidateBeforeCall(taskDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call delegateTaskCall(String id, UserIdDto userIdDto, ApiCallback _callback) throws ApiException {
        UserIdDto localVarPostBody = userIdDto;
        String localVarPath = "/task/{id}/delegate".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call delegateTaskValidateBeforeCall(String id, UserIdDto userIdDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling delegateTask(Async)");
        }
        Call localVarCall = this.delegateTaskCall(id, userIdDto, _callback);
        return localVarCall;
    }

    public void delegateTask(String id, UserIdDto userIdDto) throws ApiException {
        this.delegateTaskWithHttpInfo(id, userIdDto);
    }

    public ApiResponse<Void> delegateTaskWithHttpInfo(String id, UserIdDto userIdDto) throws ApiException {
        Call localVarCall = this.delegateTaskValidateBeforeCall(id, userIdDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call delegateTaskAsync(String id, UserIdDto userIdDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.delegateTaskValidateBeforeCall(id, userIdDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteTaskCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTaskValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTask(Async)");
        }
        Call localVarCall = this.deleteTaskCall(id, _callback);
        return localVarCall;
    }

    public void deleteTask(String id) throws ApiException {
        this.deleteTaskWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteTaskWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteTaskValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTaskAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTaskValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getDeployedFormCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/deployed-form".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeployedFormValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDeployedForm(Async)");
        }
        Call localVarCall = this.getDeployedFormCall(id, _callback);
        return localVarCall;
    }

    public File getDeployedForm(String id) throws ApiException {
        ApiResponse<File> localVarResp = this.getDeployedFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDeployedFormWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getDeployedFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeployedFormAsync(String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDeployedFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFormCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/form".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFormValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getForm(Async)");
        }
        Call localVarCall = this.getFormCall(id, _callback);
        return localVarCall;
    }

    public FormDto getForm(String id) throws ApiException {
        ApiResponse<FormDto> localVarResp = this.getFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<FormDto> getFormWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFormAsync(String id, ApiCallback<FormDto> _callback) throws ApiException {
        Call localVarCall = this.getFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFormVariablesCall(String id, String variableNames, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/form-variables".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (variableNames != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNames", variableNames));
        }
        if (deserializeValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFormVariablesValidateBeforeCall(String id, String variableNames, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getFormVariables(Async)");
        }
        Call localVarCall = this.getFormVariablesCall(id, variableNames, deserializeValues, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> getFormVariables(String id, String variableNames, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.getFormVariablesWithHttpInfo(id, variableNames, deserializeValues);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> getFormVariablesWithHttpInfo(String id, String variableNames, Boolean deserializeValues) throws ApiException {
        Call localVarCall = this.getFormVariablesValidateBeforeCall(id, variableNames, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFormVariablesAsync(String id, String variableNames, Boolean deserializeValues, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.getFormVariablesValidateBeforeCall(id, variableNames, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRenderedFormCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/rendered-form".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRenderedFormValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getRenderedForm(Async)");
        }
        Call localVarCall = this.getRenderedFormCall(id, _callback);
        return localVarCall;
    }

    public File getRenderedForm(String id) throws ApiException {
        ApiResponse<File> localVarResp = this.getRenderedFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> getRenderedFormWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getRenderedFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRenderedFormAsync(String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getRenderedFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTaskCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaskValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTask(Async)");
        }
        Call localVarCall = this.getTaskCall(id, _callback);
        return localVarCall;
    }

    public TaskDto getTask(String id) throws ApiException {
        ApiResponse<TaskDto> localVarResp = this.getTaskWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<TaskDto> getTaskWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getTaskValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<TaskDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTaskAsync(String id, ApiCallback<TaskDto> _callback) throws ApiException {
        Call localVarCall = this.getTaskValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<TaskDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTasksCall(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/task";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (taskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskId", taskId));
        }
        if (taskIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskIdIn", taskIdIn));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }
        if (processInstanceBusinessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        }
        if (processInstanceBusinessKeyExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyExpression", processInstanceBusinessKeyExpression));
        }
        if (processInstanceBusinessKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        }
        if (processInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        }
        if (processInstanceBusinessKeyLikeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyLikeExpression", processInstanceBusinessKeyLikeExpression));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (processDefinitionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionName", processDefinitionName));
        }
        if (processDefinitionNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        }
        if (executionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executionId", executionId));
        }
        if (caseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }
        if (caseInstanceBusinessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceBusinessKey", caseInstanceBusinessKey));
        }
        if (caseInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceBusinessKeyLike", caseInstanceBusinessKeyLike));
        }
        if (caseDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        }
        if (caseDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
        }
        if (caseDefinitionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseDefinitionName", caseDefinitionName));
        }
        if (caseDefinitionNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseDefinitionNameLike", caseDefinitionNameLike));
        }
        if (caseExecutionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseExecutionId", caseExecutionId));
        }
        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (assignee != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assignee", assignee));
        }
        if (assigneeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeExpression", assigneeExpression));
        }
        if (assigneeLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeLike", assigneeLike));
        }
        if (assigneeLikeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeLikeExpression", assigneeLikeExpression));
        }
        if (assigneeIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeIn", assigneeIn));
        }
        if (assigneeNotIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeNotIn", assigneeNotIn));
        }
        if (owner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("owner", owner));
        }
        if (ownerExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ownerExpression", ownerExpression));
        }
        if (candidateGroup != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateGroup", candidateGroup));
        }
        if (candidateGroupExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateGroupExpression", candidateGroupExpression));
        }
        if (candidateUser != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateUser", candidateUser));
        }
        if (candidateUserExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateUserExpression", candidateUserExpression));
        }
        if (includeAssignedTasks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeAssignedTasks", includeAssignedTasks));
        }
        if (involvedUser != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("involvedUser", involvedUser));
        }
        if (involvedUserExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("involvedUserExpression", involvedUserExpression));
        }
        if (assigned != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigned", assigned));
        }
        if (unassigned != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unassigned", unassigned));
        }
        if (taskDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskDefinitionKey", taskDefinitionKey));
        }
        if (taskDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskDefinitionKeyIn", taskDefinitionKeyIn));
        }
        if (taskDefinitionKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskDefinitionKeyLike", taskDefinitionKeyLike));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameNotEqual != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameNotEqual", nameNotEqual));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (nameNotLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameNotLike", nameNotLike));
        }
        if (description != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("description", description));
        }
        if (descriptionLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("descriptionLike", descriptionLike));
        }
        if (priority != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priority", priority));
        }
        if (maxPriority != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxPriority", maxPriority));
        }
        if (minPriority != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("minPriority", minPriority));
        }
        if (dueDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueDate", dueDate));
        }
        if (dueDateExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueDateExpression", dueDateExpression));
        }
        if (dueAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueAfter", dueAfter));
        }
        if (dueAfterExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueAfterExpression", dueAfterExpression));
        }
        if (dueBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueBefore", dueBefore));
        }
        if (dueBeforeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueBeforeExpression", dueBeforeExpression));
        }
        if (withoutDueDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutDueDate", withoutDueDate));
        }
        if (followUpDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpDate", followUpDate));
        }
        if (followUpDateExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpDateExpression", followUpDateExpression));
        }
        if (followUpAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpAfter", followUpAfter));
        }
        if (followUpAfterExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpAfterExpression", followUpAfterExpression));
        }
        if (followUpBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpBefore", followUpBefore));
        }
        if (followUpBeforeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpBeforeExpression", followUpBeforeExpression));
        }
        if (followUpBeforeOrNotExistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpBeforeOrNotExistent", followUpBeforeOrNotExistent));
        }
        if (followUpBeforeOrNotExistentExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpBeforeOrNotExistentExpression", followUpBeforeOrNotExistentExpression));
        }
        if (createdOn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdOn", createdOn));
        }
        if (createdOnExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdOnExpression", createdOnExpression));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdAfterExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdAfterExpression", createdAfterExpression));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (createdBeforeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdBeforeExpression", createdBeforeExpression));
        }
        if (updatedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedAfter", updatedAfter));
        }
        if (updatedAfterExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedAfterExpression", updatedAfterExpression));
        }
        if (delegationState != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("delegationState", delegationState));
        }
        if (candidateGroups != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateGroups", candidateGroups));
        }
        if (candidateGroupsExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateGroupsExpression", candidateGroupsExpression));
        }
        if (withCandidateGroups != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withCandidateGroups", withCandidateGroups));
        }
        if (withoutCandidateGroups != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutCandidateGroups", withoutCandidateGroups));
        }
        if (withCandidateUsers != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withCandidateUsers", withCandidateUsers));
        }
        if (withoutCandidateUsers != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutCandidateUsers", withoutCandidateUsers));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (taskVariables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskVariables", taskVariables));
        }
        if (processVariables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processVariables", processVariables));
        }
        if (caseInstanceVariables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceVariables", caseInstanceVariables));
        }
        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }
        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }
        if (parentTaskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parentTaskId", parentTaskId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTasksValidateBeforeCall(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTasksCall(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<TaskDto> getTasks(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<TaskDto>> localVarResp = this.getTasksWithHttpInfo(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<TaskDto>> getTasksWithHttpInfo(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getTasksValidateBeforeCall(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<TaskDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTasksAsync(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<TaskDto>> _callback) throws ApiException {
        Call localVarCall = this.getTasksValidateBeforeCall(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<TaskDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTasksCountCall(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/task/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (taskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskId", taskId));
        }
        if (taskIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskIdIn", taskIdIn));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }
        if (processInstanceBusinessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKey", processInstanceBusinessKey));
        }
        if (processInstanceBusinessKeyExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyExpression", processInstanceBusinessKeyExpression));
        }
        if (processInstanceBusinessKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn));
        }
        if (processInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike));
        }
        if (processInstanceBusinessKeyLikeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceBusinessKeyLikeExpression", processInstanceBusinessKeyLikeExpression));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (processDefinitionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionName", processDefinitionName));
        }
        if (processDefinitionNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionNameLike", processDefinitionNameLike));
        }
        if (executionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executionId", executionId));
        }
        if (caseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }
        if (caseInstanceBusinessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceBusinessKey", caseInstanceBusinessKey));
        }
        if (caseInstanceBusinessKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceBusinessKeyLike", caseInstanceBusinessKeyLike));
        }
        if (caseDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        }
        if (caseDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
        }
        if (caseDefinitionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseDefinitionName", caseDefinitionName));
        }
        if (caseDefinitionNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseDefinitionNameLike", caseDefinitionNameLike));
        }
        if (caseExecutionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseExecutionId", caseExecutionId));
        }
        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (assignee != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assignee", assignee));
        }
        if (assigneeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeExpression", assigneeExpression));
        }
        if (assigneeLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeLike", assigneeLike));
        }
        if (assigneeLikeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeLikeExpression", assigneeLikeExpression));
        }
        if (assigneeIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeIn", assigneeIn));
        }
        if (assigneeNotIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigneeNotIn", assigneeNotIn));
        }
        if (owner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("owner", owner));
        }
        if (ownerExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ownerExpression", ownerExpression));
        }
        if (candidateGroup != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateGroup", candidateGroup));
        }
        if (candidateGroupExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateGroupExpression", candidateGroupExpression));
        }
        if (candidateUser != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateUser", candidateUser));
        }
        if (candidateUserExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateUserExpression", candidateUserExpression));
        }
        if (includeAssignedTasks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeAssignedTasks", includeAssignedTasks));
        }
        if (involvedUser != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("involvedUser", involvedUser));
        }
        if (involvedUserExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("involvedUserExpression", involvedUserExpression));
        }
        if (assigned != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("assigned", assigned));
        }
        if (unassigned != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unassigned", unassigned));
        }
        if (taskDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskDefinitionKey", taskDefinitionKey));
        }
        if (taskDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskDefinitionKeyIn", taskDefinitionKeyIn));
        }
        if (taskDefinitionKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskDefinitionKeyLike", taskDefinitionKeyLike));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameNotEqual != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameNotEqual", nameNotEqual));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (nameNotLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameNotLike", nameNotLike));
        }
        if (description != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("description", description));
        }
        if (descriptionLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("descriptionLike", descriptionLike));
        }
        if (priority != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priority", priority));
        }
        if (maxPriority != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxPriority", maxPriority));
        }
        if (minPriority != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("minPriority", minPriority));
        }
        if (dueDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueDate", dueDate));
        }
        if (dueDateExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueDateExpression", dueDateExpression));
        }
        if (dueAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueAfter", dueAfter));
        }
        if (dueAfterExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueAfterExpression", dueAfterExpression));
        }
        if (dueBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueBefore", dueBefore));
        }
        if (dueBeforeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueBeforeExpression", dueBeforeExpression));
        }
        if (withoutDueDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutDueDate", withoutDueDate));
        }
        if (followUpDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpDate", followUpDate));
        }
        if (followUpDateExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpDateExpression", followUpDateExpression));
        }
        if (followUpAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpAfter", followUpAfter));
        }
        if (followUpAfterExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpAfterExpression", followUpAfterExpression));
        }
        if (followUpBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpBefore", followUpBefore));
        }
        if (followUpBeforeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpBeforeExpression", followUpBeforeExpression));
        }
        if (followUpBeforeOrNotExistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpBeforeOrNotExistent", followUpBeforeOrNotExistent));
        }
        if (followUpBeforeOrNotExistentExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("followUpBeforeOrNotExistentExpression", followUpBeforeOrNotExistentExpression));
        }
        if (createdOn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdOn", createdOn));
        }
        if (createdOnExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdOnExpression", createdOnExpression));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdAfterExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdAfterExpression", createdAfterExpression));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (createdBeforeExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdBeforeExpression", createdBeforeExpression));
        }
        if (updatedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedAfter", updatedAfter));
        }
        if (updatedAfterExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedAfterExpression", updatedAfterExpression));
        }
        if (delegationState != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("delegationState", delegationState));
        }
        if (candidateGroups != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateGroups", candidateGroups));
        }
        if (candidateGroupsExpression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("candidateGroupsExpression", candidateGroupsExpression));
        }
        if (withCandidateGroups != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withCandidateGroups", withCandidateGroups));
        }
        if (withoutCandidateGroups != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutCandidateGroups", withoutCandidateGroups));
        }
        if (withCandidateUsers != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withCandidateUsers", withCandidateUsers));
        }
        if (withoutCandidateUsers != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutCandidateUsers", withoutCandidateUsers));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (taskVariables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taskVariables", taskVariables));
        }
        if (processVariables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processVariables", processVariables));
        }
        if (caseInstanceVariables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceVariables", caseInstanceVariables));
        }
        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }
        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }
        if (parentTaskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parentTaskId", parentTaskId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTasksCountValidateBeforeCall(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTasksCountCall(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, _callback);
        return localVarCall;
    }

    public CountResultDto getTasksCount(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getTasksCountWithHttpInfo(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getTasksCountWithHttpInfo(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId) throws ApiException {
        Call localVarCall = this.getTasksCountValidateBeforeCall(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTasksCountAsync(String taskId, String taskIdIn, String processInstanceId, String processInstanceIdIn, String processInstanceBusinessKey, String processInstanceBusinessKeyExpression, String processInstanceBusinessKeyIn, String processInstanceBusinessKeyLike, String processInstanceBusinessKeyLikeExpression, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionName, String processDefinitionNameLike, String executionId, String caseInstanceId, String caseInstanceBusinessKey, String caseInstanceBusinessKeyLike, String caseDefinitionId, String caseDefinitionKey, String caseDefinitionName, String caseDefinitionNameLike, String caseExecutionId, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String assignee, String assigneeExpression, String assigneeLike, String assigneeLikeExpression, String assigneeIn, String assigneeNotIn, String owner, String ownerExpression, String candidateGroup, String candidateGroupExpression, String candidateUser, String candidateUserExpression, Boolean includeAssignedTasks, String involvedUser, String involvedUserExpression, Boolean assigned, Boolean unassigned, String taskDefinitionKey, String taskDefinitionKeyIn, String taskDefinitionKeyLike, String name, String nameNotEqual, String nameLike, String nameNotLike, String description, String descriptionLike, Integer priority, Integer maxPriority, Integer minPriority, String dueDate, String dueDateExpression, String dueAfter, String dueAfterExpression, String dueBefore, String dueBeforeExpression, Boolean withoutDueDate, String followUpDate, String followUpDateExpression, String followUpAfter, String followUpAfterExpression, String followUpBefore, String followUpBeforeExpression, String followUpBeforeOrNotExistent, String followUpBeforeOrNotExistentExpression, String createdOn, String createdOnExpression, String createdAfter, String createdAfterExpression, String createdBefore, String createdBeforeExpression, String updatedAfter, String updatedAfterExpression, String delegationState, String candidateGroups, String candidateGroupsExpression, Boolean withCandidateGroups, Boolean withoutCandidateGroups, Boolean withCandidateUsers, Boolean withoutCandidateUsers, Boolean active, Boolean suspended, String taskVariables, String processVariables, String caseInstanceVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String parentTaskId, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getTasksCountValidateBeforeCall(taskId, taskIdIn, processInstanceId, processInstanceIdIn, processInstanceBusinessKey, processInstanceBusinessKeyExpression, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, processInstanceBusinessKeyLikeExpression, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, executionId, caseInstanceId, caseInstanceBusinessKey, caseInstanceBusinessKeyLike, caseDefinitionId, caseDefinitionKey, caseDefinitionName, caseDefinitionNameLike, caseExecutionId, activityInstanceIdIn, tenantIdIn, withoutTenantId, assignee, assigneeExpression, assigneeLike, assigneeLikeExpression, assigneeIn, assigneeNotIn, owner, ownerExpression, candidateGroup, candidateGroupExpression, candidateUser, candidateUserExpression, includeAssignedTasks, involvedUser, involvedUserExpression, assigned, unassigned, taskDefinitionKey, taskDefinitionKeyIn, taskDefinitionKeyLike, name, nameNotEqual, nameLike, nameNotLike, description, descriptionLike, priority, maxPriority, minPriority, dueDate, dueDateExpression, dueAfter, dueAfterExpression, dueBefore, dueBeforeExpression, withoutDueDate, followUpDate, followUpDateExpression, followUpAfter, followUpAfterExpression, followUpBefore, followUpBeforeExpression, followUpBeforeOrNotExistent, followUpBeforeOrNotExistentExpression, createdOn, createdOnExpression, createdAfter, createdAfterExpression, createdBefore, createdBeforeExpression, updatedAfter, updatedAfterExpression, delegationState, candidateGroups, candidateGroupsExpression, withCandidateGroups, withoutCandidateGroups, withCandidateUsers, withoutCandidateUsers, active, suspended, taskVariables, processVariables, caseInstanceVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, parentTaskId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call handleBpmnErrorCall(String id, TaskBpmnErrorDto taskBpmnErrorDto, ApiCallback _callback) throws ApiException {
        TaskBpmnErrorDto localVarPostBody = taskBpmnErrorDto;
        String localVarPath = "/task/{id}/bpmnError".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call handleBpmnErrorValidateBeforeCall(String id, TaskBpmnErrorDto taskBpmnErrorDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling handleBpmnError(Async)");
        }
        Call localVarCall = this.handleBpmnErrorCall(id, taskBpmnErrorDto, _callback);
        return localVarCall;
    }

    public void handleBpmnError(String id, TaskBpmnErrorDto taskBpmnErrorDto) throws ApiException {
        this.handleBpmnErrorWithHttpInfo(id, taskBpmnErrorDto);
    }

    public ApiResponse<Void> handleBpmnErrorWithHttpInfo(String id, TaskBpmnErrorDto taskBpmnErrorDto) throws ApiException {
        Call localVarCall = this.handleBpmnErrorValidateBeforeCall(id, taskBpmnErrorDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call handleBpmnErrorAsync(String id, TaskBpmnErrorDto taskBpmnErrorDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.handleBpmnErrorValidateBeforeCall(id, taskBpmnErrorDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call handleEscalationCall(String id, TaskEscalationDto taskEscalationDto, ApiCallback _callback) throws ApiException {
        TaskEscalationDto localVarPostBody = taskEscalationDto;
        String localVarPath = "/task/{id}/bpmnEscalation".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call handleEscalationValidateBeforeCall(String id, TaskEscalationDto taskEscalationDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling handleEscalation(Async)");
        }
        Call localVarCall = this.handleEscalationCall(id, taskEscalationDto, _callback);
        return localVarCall;
    }

    public void handleEscalation(String id, TaskEscalationDto taskEscalationDto) throws ApiException {
        this.handleEscalationWithHttpInfo(id, taskEscalationDto);
    }

    public ApiResponse<Void> handleEscalationWithHttpInfo(String id, TaskEscalationDto taskEscalationDto) throws ApiException {
        Call localVarCall = this.handleEscalationValidateBeforeCall(id, taskEscalationDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call handleEscalationAsync(String id, TaskEscalationDto taskEscalationDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.handleEscalationValidateBeforeCall(id, taskEscalationDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call queryTasksCall(Integer firstResult, Integer maxResults, TaskQueryDto taskQueryDto, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        TaskQueryDto localVarPostBody = taskQueryDto;
        String localVarPath = "/task";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryTasksValidateBeforeCall(Integer firstResult, Integer maxResults, TaskQueryDto taskQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryTasksCall(firstResult, maxResults, taskQueryDto, _callback);
        return localVarCall;
    }

    public List<TaskDto> queryTasks(Integer firstResult, Integer maxResults, TaskQueryDto taskQueryDto) throws ApiException {
        ApiResponse<List<TaskDto>> localVarResp = this.queryTasksWithHttpInfo(firstResult, maxResults, taskQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<TaskDto>> queryTasksWithHttpInfo(Integer firstResult, Integer maxResults, TaskQueryDto taskQueryDto) throws ApiException {
        Call localVarCall = this.queryTasksValidateBeforeCall(firstResult, maxResults, taskQueryDto, null);
        Type localVarReturnType = new TypeToken<List<TaskDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryTasksAsync(Integer firstResult, Integer maxResults, TaskQueryDto taskQueryDto, ApiCallback<List<TaskDto>> _callback) throws ApiException {
        Call localVarCall = this.queryTasksValidateBeforeCall(firstResult, maxResults, taskQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<TaskDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryTasksCountCall(TaskQueryDto taskQueryDto, ApiCallback _callback) throws ApiException {
        TaskQueryDto localVarPostBody = taskQueryDto;
        String localVarPath = "/task/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryTasksCountValidateBeforeCall(TaskQueryDto taskQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryTasksCountCall(taskQueryDto, _callback);
        return localVarCall;
    }

    public CountResultDto queryTasksCount(TaskQueryDto taskQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.queryTasksCountWithHttpInfo(taskQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> queryTasksCountWithHttpInfo(TaskQueryDto taskQueryDto) throws ApiException {
        Call localVarCall = this.queryTasksCountValidateBeforeCall(taskQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryTasksCountAsync(TaskQueryDto taskQueryDto, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.queryTasksCountValidateBeforeCall(taskQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resolveCall(String id, CompleteTaskDto completeTaskDto, ApiCallback _callback) throws ApiException {
        CompleteTaskDto localVarPostBody = completeTaskDto;
        String localVarPath = "/task/{id}/resolve".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resolveValidateBeforeCall(String id, CompleteTaskDto completeTaskDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling resolve(Async)");
        }
        Call localVarCall = this.resolveCall(id, completeTaskDto, _callback);
        return localVarCall;
    }

    public void resolve(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        this.resolveWithHttpInfo(id, completeTaskDto);
    }

    public ApiResponse<Void> resolveWithHttpInfo(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        Call localVarCall = this.resolveValidateBeforeCall(id, completeTaskDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resolveAsync(String id, CompleteTaskDto completeTaskDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resolveValidateBeforeCall(id, completeTaskDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setAssigneeCall(String id, UserIdDto userIdDto, ApiCallback _callback) throws ApiException {
        UserIdDto localVarPostBody = userIdDto;
        String localVarPath = "/task/{id}/assignee".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setAssigneeValidateBeforeCall(String id, UserIdDto userIdDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setAssignee(Async)");
        }
        Call localVarCall = this.setAssigneeCall(id, userIdDto, _callback);
        return localVarCall;
    }

    public void setAssignee(String id, UserIdDto userIdDto) throws ApiException {
        this.setAssigneeWithHttpInfo(id, userIdDto);
    }

    public ApiResponse<Void> setAssigneeWithHttpInfo(String id, UserIdDto userIdDto) throws ApiException {
        Call localVarCall = this.setAssigneeValidateBeforeCall(id, userIdDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setAssigneeAsync(String id, UserIdDto userIdDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setAssigneeValidateBeforeCall(id, userIdDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call submitCall(String id, CompleteTaskDto completeTaskDto, ApiCallback _callback) throws ApiException {
        CompleteTaskDto localVarPostBody = completeTaskDto;
        String localVarPath = "/task/{id}/submit-form".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitValidateBeforeCall(String id, CompleteTaskDto completeTaskDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling submit(Async)");
        }
        Call localVarCall = this.submitCall(id, completeTaskDto, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> submit(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.submitWithHttpInfo(id, completeTaskDto);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> submitWithHttpInfo(String id, CompleteTaskDto completeTaskDto) throws ApiException {
        Call localVarCall = this.submitValidateBeforeCall(id, completeTaskDto, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitAsync(String id, CompleteTaskDto completeTaskDto, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.submitValidateBeforeCall(id, completeTaskDto, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unclaimCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/unclaim".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unclaimValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling unclaim(Async)");
        }
        Call localVarCall = this.unclaimCall(id, _callback);
        return localVarCall;
    }

    public void unclaim(String id) throws ApiException {
        this.unclaimWithHttpInfo(id);
    }

    public ApiResponse<Void> unclaimWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.unclaimValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call unclaimAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.unclaimValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateTaskCall(String id, TaskDto taskDto, ApiCallback _callback) throws ApiException {
        TaskDto localVarPostBody = taskDto;
        String localVarPath = "/task/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateTaskValidateBeforeCall(String id, TaskDto taskDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateTask(Async)");
        }
        Call localVarCall = this.updateTaskCall(id, taskDto, _callback);
        return localVarCall;
    }

    public void updateTask(String id, TaskDto taskDto) throws ApiException {
        this.updateTaskWithHttpInfo(id, taskDto);
    }

    public ApiResponse<Void> updateTaskWithHttpInfo(String id, TaskDto taskDto) throws ApiException {
        Call localVarCall = this.updateTaskValidateBeforeCall(id, taskDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateTaskAsync(String id, TaskDto taskDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateTaskValidateBeforeCall(id, taskDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

