/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class AuthorizationCreateDto {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
    @SerializedName(value="permissions")
    private List<String> permissions = null;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private String userId;
    public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
    @SerializedName(value="groupId")
    private String groupId;
    public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resourceType";
    @SerializedName(value="resourceType")
    private Integer resourceType;
    public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
    @SerializedName(value="resourceId")
    private String resourceId;

    public AuthorizationCreateDto type(Integer type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the authorization (0=global, 1=grant, 2=revoke). See the [User Guide](https://docs.camunda.org/manual/7.18/user-guide/process-engine/authorization-service.md#authorization-type) for more information about authorization types.")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AuthorizationCreateDto permissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public AuthorizationCreateDto addPermissionsItem(String permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of Strings holding the permissions provided by this authorization.")
    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public AuthorizationCreateDto userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the user this authorization has been created for. The value `*` represents a global authorization ranging over all users.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AuthorizationCreateDto groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the group this authorization has been created for.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public AuthorizationCreateDto resourceType(Integer resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.18/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.")
    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public AuthorizationCreateDto resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The resource Id. The value `*` represents an authorization ranging over all instances of a resource.")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationCreateDto authorizationCreateDto = (AuthorizationCreateDto)o;
        return Objects.equals(this.type, authorizationCreateDto.type) && Objects.equals(this.permissions, authorizationCreateDto.permissions) && Objects.equals(this.userId, authorizationCreateDto.userId) && Objects.equals(this.groupId, authorizationCreateDto.groupId) && Objects.equals(this.resourceType, authorizationCreateDto.resourceType) && Objects.equals(this.resourceId, authorizationCreateDto.resourceId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.permissions, this.userId, this.groupId, this.resourceType, this.resourceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationCreateDto {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

