/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class BatchStatisticsDto {
    public static final String SERIALIZED_NAME_REMAINING_JOBS = "remainingJobs";
    @SerializedName(value="remainingJobs")
    private Integer remainingJobs;
    public static final String SERIALIZED_NAME_COMPLETED_JOBS = "completedJobs";
    @SerializedName(value="completedJobs")
    private Integer completedJobs;
    public static final String SERIALIZED_NAME_FAILED_JOBS = "failedJobs";
    @SerializedName(value="failedJobs")
    private Integer failedJobs;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_TOTAL_JOBS = "totalJobs";
    @SerializedName(value="totalJobs")
    private Integer totalJobs;
    public static final String SERIALIZED_NAME_JOBS_CREATED = "jobsCreated";
    @SerializedName(value="jobsCreated")
    private Integer jobsCreated;
    public static final String SERIALIZED_NAME_BATCH_JOBS_PER_SEED = "batchJobsPerSeed";
    @SerializedName(value="batchJobsPerSeed")
    private Integer batchJobsPerSeed;
    public static final String SERIALIZED_NAME_INVOCATIONS_PER_BATCH_JOB = "invocationsPerBatchJob";
    @SerializedName(value="invocationsPerBatchJob")
    private Integer invocationsPerBatchJob;
    public static final String SERIALIZED_NAME_SEED_JOB_DEFINITION_ID = "seedJobDefinitionId";
    @SerializedName(value="seedJobDefinitionId")
    private String seedJobDefinitionId;
    public static final String SERIALIZED_NAME_MONITOR_JOB_DEFINITION_ID = "monitorJobDefinitionId";
    @SerializedName(value="monitorJobDefinitionId")
    private String monitorJobDefinitionId;
    public static final String SERIALIZED_NAME_BATCH_JOB_DEFINITION_ID = "batchJobDefinitionId";
    @SerializedName(value="batchJobDefinitionId")
    private String batchJobDefinitionId;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_CREATE_USER_ID = "createUserId";
    @SerializedName(value="createUserId")
    private String createUserId;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private Date startTime;
    public static final String SERIALIZED_NAME_EXECUTION_START_TIME = "executionStartTime";
    @SerializedName(value="executionStartTime")
    private Date executionStartTime;

    public BatchStatisticsDto remainingJobs(Integer remainingJobs) {
        this.remainingJobs = remainingJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of remaining batch execution jobs. This does include failed batch execution jobs and batch execution jobs which still have to be created by the seed job.")
    public Integer getRemainingJobs() {
        return this.remainingJobs;
    }

    public void setRemainingJobs(Integer remainingJobs) {
        this.remainingJobs = remainingJobs;
    }

    public BatchStatisticsDto completedJobs(Integer completedJobs) {
        this.completedJobs = completedJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of completed batch execution jobs. This does include aborted/deleted batch execution jobs.")
    public Integer getCompletedJobs() {
        return this.completedJobs;
    }

    public void setCompletedJobs(Integer completedJobs) {
        this.completedJobs = completedJobs;
    }

    public BatchStatisticsDto failedJobs(Integer failedJobs) {
        this.failedJobs = failedJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of failed batch execution jobs. This does not include aborted or deleted batch execution jobs.")
    public Integer getFailedJobs() {
        return this.failedJobs;
    }

    public void setFailedJobs(Integer failedJobs) {
        this.failedJobs = failedJobs;
    }

    public BatchStatisticsDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the batch.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BatchStatisticsDto type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the batch. See the [User Guide](https://docs.camunda.org/manual/7.18/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BatchStatisticsDto totalJobs(Integer totalJobs) {
        this.totalJobs = totalJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total jobs of a batch is the number of batch execution jobs required to complete the batch.")
    public Integer getTotalJobs() {
        return this.totalJobs;
    }

    public void setTotalJobs(Integer totalJobs) {
        this.totalJobs = totalJobs;
    }

    public BatchStatisticsDto jobsCreated(Integer jobsCreated) {
        this.jobsCreated = jobsCreated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of batch execution jobs already created by the seed job.")
    public Integer getJobsCreated() {
        return this.jobsCreated;
    }

    public void setJobsCreated(Integer jobsCreated) {
        this.jobsCreated = jobsCreated;
    }

    public BatchStatisticsDto batchJobsPerSeed(Integer batchJobsPerSeed) {
        this.batchJobsPerSeed = batchJobsPerSeed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of batch execution jobs created per seed job invocation. The batch seed job is invoked until it has created all batch execution jobs required by the batch (see `totalJobs` property).")
    public Integer getBatchJobsPerSeed() {
        return this.batchJobsPerSeed;
    }

    public void setBatchJobsPerSeed(Integer batchJobsPerSeed) {
        this.batchJobsPerSeed = batchJobsPerSeed;
    }

    public BatchStatisticsDto invocationsPerBatchJob(Integer invocationsPerBatchJob) {
        this.invocationsPerBatchJob = invocationsPerBatchJob;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Every batch execution job invokes the command executed by the batch `invocationsPerBatchJob` times. E.g., for a process instance migration batch this specifies the number of process instances which are migrated per batch execution job.")
    public Integer getInvocationsPerBatchJob() {
        return this.invocationsPerBatchJob;
    }

    public void setInvocationsPerBatchJob(Integer invocationsPerBatchJob) {
        this.invocationsPerBatchJob = invocationsPerBatchJob;
    }

    public BatchStatisticsDto seedJobDefinitionId(String seedJobDefinitionId) {
        this.seedJobDefinitionId = seedJobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id for the seed jobs of this batch.")
    public String getSeedJobDefinitionId() {
        return this.seedJobDefinitionId;
    }

    public void setSeedJobDefinitionId(String seedJobDefinitionId) {
        this.seedJobDefinitionId = seedJobDefinitionId;
    }

    public BatchStatisticsDto monitorJobDefinitionId(String monitorJobDefinitionId) {
        this.monitorJobDefinitionId = monitorJobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id for the monitor jobs of this batch.")
    public String getMonitorJobDefinitionId() {
        return this.monitorJobDefinitionId;
    }

    public void setMonitorJobDefinitionId(String monitorJobDefinitionId) {
        this.monitorJobDefinitionId = monitorJobDefinitionId;
    }

    public BatchStatisticsDto batchJobDefinitionId(String batchJobDefinitionId) {
        this.batchJobDefinitionId = batchJobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id for the batch execution jobs of this batch.")
    public String getBatchJobDefinitionId() {
        return this.batchJobDefinitionId;
    }

    public void setBatchJobDefinitionId(String batchJobDefinitionId) {
        this.batchJobDefinitionId = batchJobDefinitionId;
    }

    public BatchStatisticsDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether this batch is suspended or not.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public BatchStatisticsDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the batch.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public BatchStatisticsDto createUserId(String createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the user that created the batch.")
    public String getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public BatchStatisticsDto startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the batch was started. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation] (https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/)")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public BatchStatisticsDto executionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the batch execution was started, i.e., at least one batch job has been executed. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation] (https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/)")
    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchStatisticsDto batchStatisticsDto = (BatchStatisticsDto)o;
        return Objects.equals(this.remainingJobs, batchStatisticsDto.remainingJobs) && Objects.equals(this.completedJobs, batchStatisticsDto.completedJobs) && Objects.equals(this.failedJobs, batchStatisticsDto.failedJobs) && Objects.equals(this.id, batchStatisticsDto.id) && Objects.equals(this.type, batchStatisticsDto.type) && Objects.equals(this.totalJobs, batchStatisticsDto.totalJobs) && Objects.equals(this.jobsCreated, batchStatisticsDto.jobsCreated) && Objects.equals(this.batchJobsPerSeed, batchStatisticsDto.batchJobsPerSeed) && Objects.equals(this.invocationsPerBatchJob, batchStatisticsDto.invocationsPerBatchJob) && Objects.equals(this.seedJobDefinitionId, batchStatisticsDto.seedJobDefinitionId) && Objects.equals(this.monitorJobDefinitionId, batchStatisticsDto.monitorJobDefinitionId) && Objects.equals(this.batchJobDefinitionId, batchStatisticsDto.batchJobDefinitionId) && Objects.equals(this.suspended, batchStatisticsDto.suspended) && Objects.equals(this.tenantId, batchStatisticsDto.tenantId) && Objects.equals(this.createUserId, batchStatisticsDto.createUserId) && Objects.equals(this.startTime, batchStatisticsDto.startTime) && Objects.equals(this.executionStartTime, batchStatisticsDto.executionStartTime);
    }

    public int hashCode() {
        return Objects.hash(this.remainingJobs, this.completedJobs, this.failedJobs, this.id, this.type, this.totalJobs, this.jobsCreated, this.batchJobsPerSeed, this.invocationsPerBatchJob, this.seedJobDefinitionId, this.monitorJobDefinitionId, this.batchJobDefinitionId, this.suspended, this.tenantId, this.createUserId, this.startTime, this.executionStartTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchStatisticsDto {\n");
        sb.append("    remainingJobs: ").append(this.toIndentedString(this.remainingJobs)).append("\n");
        sb.append("    completedJobs: ").append(this.toIndentedString(this.completedJobs)).append("\n");
        sb.append("    failedJobs: ").append(this.toIndentedString(this.failedJobs)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    totalJobs: ").append(this.toIndentedString(this.totalJobs)).append("\n");
        sb.append("    jobsCreated: ").append(this.toIndentedString(this.jobsCreated)).append("\n");
        sb.append("    batchJobsPerSeed: ").append(this.toIndentedString(this.batchJobsPerSeed)).append("\n");
        sb.append("    invocationsPerBatchJob: ").append(this.toIndentedString(this.invocationsPerBatchJob)).append("\n");
        sb.append("    seedJobDefinitionId: ").append(this.toIndentedString(this.seedJobDefinitionId)).append("\n");
        sb.append("    monitorJobDefinitionId: ").append(this.toIndentedString(this.monitorJobDefinitionId)).append("\n");
        sb.append("    batchJobDefinitionId: ").append(this.toIndentedString(this.batchJobDefinitionId)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    createUserId: ").append(this.toIndentedString(this.createUserId)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    executionStartTime: ").append(this.toIndentedString(this.executionStartTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

