/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class CommentDtoAllOf {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private String userId;
    public static final String SERIALIZED_NAME_TASK_ID = "taskId";
    @SerializedName(value="taskId")
    private String taskId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    private Date time;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;

    public CommentDtoAllOf id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the task comment.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CommentDtoAllOf userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the user who created the comment.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public CommentDtoAllOf taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the task to which the comment belongs.")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public CommentDtoAllOf processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance the comment is related to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public CommentDtoAllOf time(Date time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the comment was created. [Default format]($(docsUrl)/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public CommentDtoAllOf message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The content of the comment.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CommentDtoAllOf removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the comment should be removed by the History Cleanup job. [Default format]($(docsUrl)/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public CommentDtoAllOf rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance that initiated the process containing the task.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentDtoAllOf commentDtoAllOf = (CommentDtoAllOf)o;
        return Objects.equals(this.id, commentDtoAllOf.id) && Objects.equals(this.userId, commentDtoAllOf.userId) && Objects.equals(this.taskId, commentDtoAllOf.taskId) && Objects.equals(this.processInstanceId, commentDtoAllOf.processInstanceId) && Objects.equals(this.time, commentDtoAllOf.time) && Objects.equals(this.message, commentDtoAllOf.message) && Objects.equals(this.removalTime, commentDtoAllOf.removalTime) && Objects.equals(this.rootProcessInstanceId, commentDtoAllOf.rootProcessInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.taskId, this.processInstanceId, this.time, this.message, this.removalTime, this.rootProcessInstanceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommentDtoAllOf {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

