/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricBatchDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_TOTAL_JOBS = "totalJobs";
    @SerializedName(value="totalJobs")
    private Integer totalJobs;
    public static final String SERIALIZED_NAME_BATCH_JOBS_PER_SEED = "batchJobsPerSeed";
    @SerializedName(value="batchJobsPerSeed")
    private Integer batchJobsPerSeed;
    public static final String SERIALIZED_NAME_INVOCATIONS_PER_BATCH_JOB = "invocationsPerBatchJob";
    @SerializedName(value="invocationsPerBatchJob")
    private Integer invocationsPerBatchJob;
    public static final String SERIALIZED_NAME_SEED_JOB_DEFINITION_ID = "seedJobDefinitionId";
    @SerializedName(value="seedJobDefinitionId")
    private String seedJobDefinitionId;
    public static final String SERIALIZED_NAME_MONITOR_JOB_DEFINITION_ID = "monitorJobDefinitionId";
    @SerializedName(value="monitorJobDefinitionId")
    private String monitorJobDefinitionId;
    public static final String SERIALIZED_NAME_BATCH_JOB_DEFINITION_ID = "batchJobDefinitionId";
    @SerializedName(value="batchJobDefinitionId")
    private String batchJobDefinitionId;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_CREATE_USER_ID = "createUserId";
    @SerializedName(value="createUserId")
    private String createUserId;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private Date startTime;
    public static final String SERIALIZED_NAME_EXECUTION_START_TIME = "executionStartTime";
    @SerializedName(value="executionStartTime")
    private Date executionStartTime;
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    private Date endTime;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;

    public HistoricBatchDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the batch.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricBatchDto type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the batch. See the [User Guide](https://docs.camunda.org/manual/7.18/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public HistoricBatchDto totalJobs(Integer totalJobs) {
        this.totalJobs = totalJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value=" The total jobs of a batch is the number of batch execution jobs required to complete the batch. ")
    public Integer getTotalJobs() {
        return this.totalJobs;
    }

    public void setTotalJobs(Integer totalJobs) {
        this.totalJobs = totalJobs;
    }

    public HistoricBatchDto batchJobsPerSeed(Integer batchJobsPerSeed) {
        this.batchJobsPerSeed = batchJobsPerSeed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value=" The number of batch execution jobs created per seed job invocation. The batch seed job is invoked until it has created all batch execution jobs required by the batch (see `totalJobs` property). ")
    public Integer getBatchJobsPerSeed() {
        return this.batchJobsPerSeed;
    }

    public void setBatchJobsPerSeed(Integer batchJobsPerSeed) {
        this.batchJobsPerSeed = batchJobsPerSeed;
    }

    public HistoricBatchDto invocationsPerBatchJob(Integer invocationsPerBatchJob) {
        this.invocationsPerBatchJob = invocationsPerBatchJob;
        return this;
    }

    @Nullable
    @ApiModelProperty(value=" Every batch execution job invokes the command executed by the batch `invocationsPerBatchJob` times. E.g., for a process instance migration batch this specifies the number of process instances which are migrated per batch execution job. ")
    public Integer getInvocationsPerBatchJob() {
        return this.invocationsPerBatchJob;
    }

    public void setInvocationsPerBatchJob(Integer invocationsPerBatchJob) {
        this.invocationsPerBatchJob = invocationsPerBatchJob;
    }

    public HistoricBatchDto seedJobDefinitionId(String seedJobDefinitionId) {
        this.seedJobDefinitionId = seedJobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id for the seed jobs of this batch.")
    public String getSeedJobDefinitionId() {
        return this.seedJobDefinitionId;
    }

    public void setSeedJobDefinitionId(String seedJobDefinitionId) {
        this.seedJobDefinitionId = seedJobDefinitionId;
    }

    public HistoricBatchDto monitorJobDefinitionId(String monitorJobDefinitionId) {
        this.monitorJobDefinitionId = monitorJobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id for the monitor jobs of this batch.")
    public String getMonitorJobDefinitionId() {
        return this.monitorJobDefinitionId;
    }

    public void setMonitorJobDefinitionId(String monitorJobDefinitionId) {
        this.monitorJobDefinitionId = monitorJobDefinitionId;
    }

    public HistoricBatchDto batchJobDefinitionId(String batchJobDefinitionId) {
        this.batchJobDefinitionId = batchJobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id for the batch execution jobs of this batch.")
    public String getBatchJobDefinitionId() {
        return this.batchJobDefinitionId;
    }

    public void setBatchJobDefinitionId(String batchJobDefinitionId) {
        this.batchJobDefinitionId = batchJobDefinitionId;
    }

    public HistoricBatchDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the batch.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public HistoricBatchDto createUserId(String createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The batch creator's user id.")
    public String getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public HistoricBatchDto startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the batch was started. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/)")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public HistoricBatchDto executionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the batch execution was started, i.e., at least one batch job has been executed. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation] (https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/)")
    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public HistoricBatchDto endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the batch ended. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/)")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public HistoricBatchDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the historic batch should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/)")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricBatchDto historicBatchDto = (HistoricBatchDto)o;
        return Objects.equals(this.id, historicBatchDto.id) && Objects.equals(this.type, historicBatchDto.type) && Objects.equals(this.totalJobs, historicBatchDto.totalJobs) && Objects.equals(this.batchJobsPerSeed, historicBatchDto.batchJobsPerSeed) && Objects.equals(this.invocationsPerBatchJob, historicBatchDto.invocationsPerBatchJob) && Objects.equals(this.seedJobDefinitionId, historicBatchDto.seedJobDefinitionId) && Objects.equals(this.monitorJobDefinitionId, historicBatchDto.monitorJobDefinitionId) && Objects.equals(this.batchJobDefinitionId, historicBatchDto.batchJobDefinitionId) && Objects.equals(this.tenantId, historicBatchDto.tenantId) && Objects.equals(this.createUserId, historicBatchDto.createUserId) && Objects.equals(this.startTime, historicBatchDto.startTime) && Objects.equals(this.executionStartTime, historicBatchDto.executionStartTime) && Objects.equals(this.endTime, historicBatchDto.endTime) && Objects.equals(this.removalTime, historicBatchDto.removalTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.totalJobs, this.batchJobsPerSeed, this.invocationsPerBatchJob, this.seedJobDefinitionId, this.monitorJobDefinitionId, this.batchJobDefinitionId, this.tenantId, this.createUserId, this.startTime, this.executionStartTime, this.endTime, this.removalTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricBatchDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    totalJobs: ").append(this.toIndentedString(this.totalJobs)).append("\n");
        sb.append("    batchJobsPerSeed: ").append(this.toIndentedString(this.batchJobsPerSeed)).append("\n");
        sb.append("    invocationsPerBatchJob: ").append(this.toIndentedString(this.invocationsPerBatchJob)).append("\n");
        sb.append("    seedJobDefinitionId: ").append(this.toIndentedString(this.seedJobDefinitionId)).append("\n");
        sb.append("    monitorJobDefinitionId: ").append(this.toIndentedString(this.monitorJobDefinitionId)).append("\n");
        sb.append("    batchJobDefinitionId: ").append(this.toIndentedString(this.batchJobDefinitionId)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    createUserId: ").append(this.toIndentedString(this.createUserId)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    executionStartTime: ").append(this.toIndentedString(this.executionStartTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

