/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricExternalTaskLogDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_EXTERNAL_TASK_ID = "externalTaskId";
    @SerializedName(value="externalTaskId")
    private String externalTaskId;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Date timestamp;
    public static final String SERIALIZED_NAME_TOPIC_NAME = "topicName";
    @SerializedName(value="topicName")
    private String topicName;
    public static final String SERIALIZED_NAME_WORKER_ID = "workerId";
    @SerializedName(value="workerId")
    private String workerId;
    public static final String SERIALIZED_NAME_RETRIES = "retries";
    @SerializedName(value="retries")
    private Integer retries;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Long priority;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    @SerializedName(value="activityInstanceId")
    private String activityInstanceId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_CREATION_LOG = "creationLog";
    @SerializedName(value="creationLog")
    private Boolean creationLog;
    public static final String SERIALIZED_NAME_FAILURE_LOG = "failureLog";
    @SerializedName(value="failureLog")
    private Boolean failureLog;
    public static final String SERIALIZED_NAME_SUCCESS_LOG = "successLog";
    @SerializedName(value="successLog")
    private Boolean successLog;
    public static final String SERIALIZED_NAME_DELETION_LOG = "deletionLog";
    @SerializedName(value="deletionLog")
    private Boolean deletionLog;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;

    public HistoricExternalTaskLogDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the log entry.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricExternalTaskLogDto externalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the external task.")
    public String getExternalTaskId() {
        return this.externalTaskId;
    }

    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    public HistoricExternalTaskLogDto timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the log entry has been written.")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public HistoricExternalTaskLogDto topicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The topic name of the associated external task.")
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public HistoricExternalTaskLogDto workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the worker that posessed the most recent lock.")
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public HistoricExternalTaskLogDto retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of retries the associated external task has left.")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public HistoricExternalTaskLogDto priority(Long priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The execution priority the external task had when the log entry was created.")
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public HistoricExternalTaskLogDto errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The message of the error that occurred by executing the associated external task.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public HistoricExternalTaskLogDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity on which the associated external task was created.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public HistoricExternalTaskLogDto activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity instance on which the associated external task was created.")
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public HistoricExternalTaskLogDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The execution id on which the associated external task was created.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public HistoricExternalTaskLogDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance on which the associated external task was created.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricExternalTaskLogDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition which the associated external task belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricExternalTaskLogDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition which the associated external task belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricExternalTaskLogDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant that this historic external task log entry belongs to.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public HistoricExternalTaskLogDto creationLog(Boolean creationLog) {
        this.creationLog = creationLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether this log represents the creation of the associated external task.")
    public Boolean getCreationLog() {
        return this.creationLog;
    }

    public void setCreationLog(Boolean creationLog) {
        this.creationLog = creationLog;
    }

    public HistoricExternalTaskLogDto failureLog(Boolean failureLog) {
        this.failureLog = failureLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether this log represents the failed execution of the associated external task.")
    public Boolean getFailureLog() {
        return this.failureLog;
    }

    public void setFailureLog(Boolean failureLog) {
        this.failureLog = failureLog;
    }

    public HistoricExternalTaskLogDto successLog(Boolean successLog) {
        this.successLog = successLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether this log represents the successful execution of the associated external task.")
    public Boolean getSuccessLog() {
        return this.successLog;
    }

    public void setSuccessLog(Boolean successLog) {
        this.successLog = successLog;
    }

    public HistoricExternalTaskLogDto deletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether this log represents the deletion of the associated external task.")
    public Boolean getDeletionLog() {
        return this.deletionLog;
    }

    public void setDeletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
    }

    public HistoricExternalTaskLogDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which this log should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  For further information, please see the [documentation](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/)")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public HistoricExternalTaskLogDto rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance that initiated the process containing this log.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricExternalTaskLogDto historicExternalTaskLogDto = (HistoricExternalTaskLogDto)o;
        return Objects.equals(this.id, historicExternalTaskLogDto.id) && Objects.equals(this.externalTaskId, historicExternalTaskLogDto.externalTaskId) && Objects.equals(this.timestamp, historicExternalTaskLogDto.timestamp) && Objects.equals(this.topicName, historicExternalTaskLogDto.topicName) && Objects.equals(this.workerId, historicExternalTaskLogDto.workerId) && Objects.equals(this.retries, historicExternalTaskLogDto.retries) && Objects.equals(this.priority, historicExternalTaskLogDto.priority) && Objects.equals(this.errorMessage, historicExternalTaskLogDto.errorMessage) && Objects.equals(this.activityId, historicExternalTaskLogDto.activityId) && Objects.equals(this.activityInstanceId, historicExternalTaskLogDto.activityInstanceId) && Objects.equals(this.executionId, historicExternalTaskLogDto.executionId) && Objects.equals(this.processInstanceId, historicExternalTaskLogDto.processInstanceId) && Objects.equals(this.processDefinitionId, historicExternalTaskLogDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, historicExternalTaskLogDto.processDefinitionKey) && Objects.equals(this.tenantId, historicExternalTaskLogDto.tenantId) && Objects.equals(this.creationLog, historicExternalTaskLogDto.creationLog) && Objects.equals(this.failureLog, historicExternalTaskLogDto.failureLog) && Objects.equals(this.successLog, historicExternalTaskLogDto.successLog) && Objects.equals(this.deletionLog, historicExternalTaskLogDto.deletionLog) && Objects.equals(this.removalTime, historicExternalTaskLogDto.removalTime) && Objects.equals(this.rootProcessInstanceId, historicExternalTaskLogDto.rootProcessInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.externalTaskId, this.timestamp, this.topicName, this.workerId, this.retries, this.priority, this.errorMessage, this.activityId, this.activityInstanceId, this.executionId, this.processInstanceId, this.processDefinitionId, this.processDefinitionKey, this.tenantId, this.creationLog, this.failureLog, this.successLog, this.deletionLog, this.removalTime, this.rootProcessInstanceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricExternalTaskLogDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    externalTaskId: ").append(this.toIndentedString(this.externalTaskId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    topicName: ").append(this.toIndentedString(this.topicName)).append("\n");
        sb.append("    workerId: ").append(this.toIndentedString(this.workerId)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    activityInstanceId: ").append(this.toIndentedString(this.activityInstanceId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    creationLog: ").append(this.toIndentedString(this.creationLog)).append("\n");
        sb.append("    failureLog: ").append(this.toIndentedString(this.failureLog)).append("\n");
        sb.append("    successLog: ").append(this.toIndentedString(this.successLog)).append("\n");
        sb.append("    deletionLog: ").append(this.toIndentedString(this.deletionLog)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

