/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDtoSorting;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;

@ApiModel(description="A historic process instance query which defines a group of historic process instances")
public class HistoricProcessInstanceQueryDto {
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
    @SerializedName(value="processInstanceIds")
    private List<String> processInstanceIds = null;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY_IN = "processDefinitionKeyIn";
    @SerializedName(value="processDefinitionKeyIn")
    private List<String> processDefinitionKeyIn = null;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME = "processDefinitionName";
    @SerializedName(value="processDefinitionName")
    private String processDefinitionName;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME_LIKE = "processDefinitionNameLike";
    @SerializedName(value="processDefinitionNameLike")
    private String processDefinitionNameLike;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY_NOT_IN = "processDefinitionKeyNotIn";
    @SerializedName(value="processDefinitionKeyNotIn")
    private List<String> processDefinitionKeyNotIn = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY = "processInstanceBusinessKey";
    @SerializedName(value="processInstanceBusinessKey")
    private String processInstanceBusinessKey;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_IN = "processInstanceBusinessKeyIn";
    @SerializedName(value="processInstanceBusinessKeyIn")
    private List<String> processInstanceBusinessKeyIn = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_LIKE = "processInstanceBusinessKeyLike";
    @SerializedName(value="processInstanceBusinessKeyLike")
    private String processInstanceBusinessKeyLike;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCES = "rootProcessInstances";
    @SerializedName(value="rootProcessInstances")
    private Boolean rootProcessInstances;
    public static final String SERIALIZED_NAME_FINISHED = "finished";
    @SerializedName(value="finished")
    private Boolean finished;
    public static final String SERIALIZED_NAME_UNFINISHED = "unfinished";
    @SerializedName(value="unfinished")
    private Boolean unfinished;
    public static final String SERIALIZED_NAME_WITH_INCIDENTS = "withIncidents";
    @SerializedName(value="withIncidents")
    private Boolean withIncidents;
    public static final String SERIALIZED_NAME_WITH_ROOT_INCIDENTS = "withRootIncidents";
    @SerializedName(value="withRootIncidents")
    private Boolean withRootIncidents;
    public static final String SERIALIZED_NAME_INCIDENT_TYPE = "incidentType";
    @SerializedName(value="incidentType")
    private String incidentType;
    public static final String SERIALIZED_NAME_INCIDENT_STATUS = "incidentStatus";
    @SerializedName(value="incidentStatus")
    private IncidentStatusEnum incidentStatus;
    public static final String SERIALIZED_NAME_INCIDENT_MESSAGE = "incidentMessage";
    @SerializedName(value="incidentMessage")
    private String incidentMessage;
    public static final String SERIALIZED_NAME_INCIDENT_MESSAGE_LIKE = "incidentMessageLike";
    @SerializedName(value="incidentMessageLike")
    private String incidentMessageLike;
    public static final String SERIALIZED_NAME_STARTED_BEFORE = "startedBefore";
    @SerializedName(value="startedBefore")
    private Date startedBefore;
    public static final String SERIALIZED_NAME_STARTED_AFTER = "startedAfter";
    @SerializedName(value="startedAfter")
    private Date startedAfter;
    public static final String SERIALIZED_NAME_FINISHED_BEFORE = "finishedBefore";
    @SerializedName(value="finishedBefore")
    private Date finishedBefore;
    public static final String SERIALIZED_NAME_FINISHED_AFTER = "finishedAfter";
    @SerializedName(value="finishedAfter")
    private Date finishedAfter;
    public static final String SERIALIZED_NAME_EXECUTED_ACTIVITY_AFTER = "executedActivityAfter";
    @SerializedName(value="executedActivityAfter")
    private Date executedActivityAfter;
    public static final String SERIALIZED_NAME_EXECUTED_ACTIVITY_BEFORE = "executedActivityBefore";
    @SerializedName(value="executedActivityBefore")
    private Date executedActivityBefore;
    public static final String SERIALIZED_NAME_EXECUTED_JOB_AFTER = "executedJobAfter";
    @SerializedName(value="executedJobAfter")
    private Date executedJobAfter;
    public static final String SERIALIZED_NAME_EXECUTED_JOB_BEFORE = "executedJobBefore";
    @SerializedName(value="executedJobBefore")
    private Date executedJobBefore;
    public static final String SERIALIZED_NAME_STARTED_BY = "startedBy";
    @SerializedName(value="startedBy")
    private String startedBy;
    public static final String SERIALIZED_NAME_SUPER_PROCESS_INSTANCE_ID = "superProcessInstanceId";
    @SerializedName(value="superProcessInstanceId")
    private String superProcessInstanceId;
    public static final String SERIALIZED_NAME_SUB_PROCESS_INSTANCE_ID = "subProcessInstanceId";
    @SerializedName(value="subProcessInstanceId")
    private String subProcessInstanceId;
    public static final String SERIALIZED_NAME_SUPER_CASE_INSTANCE_ID = "superCaseInstanceId";
    @SerializedName(value="superCaseInstanceId")
    private String superCaseInstanceId;
    public static final String SERIALIZED_NAME_SUB_CASE_INSTANCE_ID = "subCaseInstanceId";
    @SerializedName(value="subCaseInstanceId")
    private String subCaseInstanceId;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_EXECUTED_ACTIVITY_ID_IN = "executedActivityIdIn";
    @SerializedName(value="executedActivityIdIn")
    private List<String> executedActivityIdIn = null;
    public static final String SERIALIZED_NAME_ACTIVE_ACTIVITY_ID_IN = "activeActivityIdIn";
    @SerializedName(value="activeActivityIdIn")
    private List<String> activeActivityIdIn = null;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_COMPLETED = "completed";
    @SerializedName(value="completed")
    private Boolean completed;
    public static final String SERIALIZED_NAME_EXTERNALLY_TERMINATED = "externallyTerminated";
    @SerializedName(value="externallyTerminated")
    private Boolean externallyTerminated;
    public static final String SERIALIZED_NAME_INTERNALLY_TERMINATED = "internallyTerminated";
    @SerializedName(value="internallyTerminated")
    private Boolean internallyTerminated;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private List<VariableQueryParameterDto> variables = null;
    public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
    @SerializedName(value="variableNamesIgnoreCase")
    private Boolean variableNamesIgnoreCase;
    public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
    @SerializedName(value="variableValuesIgnoreCase")
    private Boolean variableValuesIgnoreCase;
    public static final String SERIALIZED_NAME_OR_QUERIES = "orQueries";
    @SerializedName(value="orQueries")
    private List<HistoricProcessInstanceQueryDto> orQueries = null;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<HistoricProcessInstanceQueryDtoSorting> sorting = null;

    public HistoricProcessInstanceQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance id.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricProcessInstanceQueryDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    public HistoricProcessInstanceQueryDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.add(processInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance ids. Must be a JSON array of `Strings`.")
    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public HistoricProcessInstanceQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the process definition the instances run on.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricProcessInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the key of the process definition the instances run on.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricProcessInstanceQueryDto processDefinitionKeyIn(List<String> processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
        return this;
    }

    public HistoricProcessInstanceQueryDto addProcessDefinitionKeyInItem(String processDefinitionKeyInItem) {
        if (this.processDefinitionKeyIn == null) {
            this.processDefinitionKeyIn = new ArrayList<String>();
        }
        this.processDefinitionKeyIn.add(processDefinitionKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of `Strings`.")
    public List<String> getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }

    public void setProcessDefinitionKeyIn(List<String> processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    public HistoricProcessInstanceQueryDto processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the name of the process definition the instances run on.")
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public HistoricProcessInstanceQueryDto processDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process definition names that the parameter is a substring of.")
    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    public HistoricProcessInstanceQueryDto processDefinitionKeyNotIn(List<String> processDefinitionKeyNotIn) {
        this.processDefinitionKeyNotIn = processDefinitionKeyNotIn;
        return this;
    }

    public HistoricProcessInstanceQueryDto addProcessDefinitionKeyNotInItem(String processDefinitionKeyNotInItem) {
        if (this.processDefinitionKeyNotIn == null) {
            this.processDefinitionKeyNotIn = new ArrayList<String>();
        }
        this.processDefinitionKeyNotIn.add(processDefinitionKeyNotInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Exclude instances that belong to a set of process definitions. Must be a JSON array of `Strings`.")
    public List<String> getProcessDefinitionKeyNotIn() {
        return this.processDefinitionKeyNotIn;
    }

    public void setProcessDefinitionKeyNotIn(List<String> processDefinitionKeyNotIn) {
        this.processDefinitionKeyNotIn = processDefinitionKeyNotIn;
    }

    public HistoricProcessInstanceQueryDto processInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance business key.")
    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
    }

    public HistoricProcessInstanceQueryDto processInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
        return this;
    }

    public HistoricProcessInstanceQueryDto addProcessInstanceBusinessKeyInItem(String processInstanceBusinessKeyInItem) {
        if (this.processInstanceBusinessKeyIn == null) {
            this.processInstanceBusinessKeyIn = new ArrayList<String>();
        }
        this.processInstanceBusinessKeyIn.add(processInstanceBusinessKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a list of business keys. A process instance must have one of the given business keys. Must be a JSON array of `Strings`")
    public List<String> getProcessInstanceBusinessKeyIn() {
        return this.processInstanceBusinessKeyIn;
    }

    public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    }

    public HistoricProcessInstanceQueryDto processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance business key that the parameter is a substring of.")
    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    }

    public HistoricProcessInstanceQueryDto rootProcessInstances(Boolean rootProcessInstances) {
        this.rootProcessInstances = rootProcessInstances;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict the query to all process instances that are top level process instances.")
    public Boolean getRootProcessInstances() {
        return this.rootProcessInstances;
    }

    public void setRootProcessInstances(Boolean rootProcessInstances) {
        this.rootProcessInstances = rootProcessInstances;
    }

    public HistoricProcessInstanceQueryDto finished(Boolean finished) {
        this.finished = finished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getFinished() {
        return this.finished;
    }

    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    public HistoricProcessInstanceQueryDto unfinished(Boolean unfinished) {
        this.unfinished = unfinished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include unfinished process instances. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getUnfinished() {
        return this.unfinished;
    }

    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    public HistoricProcessInstanceQueryDto withIncidents(Boolean withIncidents) {
        this.withIncidents = withIncidents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include process instances which have an incident. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithIncidents() {
        return this.withIncidents;
    }

    public void setWithIncidents(Boolean withIncidents) {
        this.withIncidents = withIncidents;
    }

    public HistoricProcessInstanceQueryDto withRootIncidents(Boolean withRootIncidents) {
        this.withRootIncidents = withRootIncidents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include process instances which have a root incident. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithRootIncidents() {
        return this.withRootIncidents;
    }

    public void setWithRootIncidents(Boolean withRootIncidents) {
        this.withRootIncidents = withRootIncidents;
    }

    public HistoricProcessInstanceQueryDto incidentType(String incidentType) {
        this.incidentType = incidentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.18/user-guide/process-engine/incidents/#incident-types) for a list of incident types.")
    public String getIncidentType() {
        return this.incidentType;
    }

    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    public HistoricProcessInstanceQueryDto incidentStatus(IncidentStatusEnum incidentStatus) {
        this.incidentStatus = incidentStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.")
    public IncidentStatusEnum getIncidentStatus() {
        return this.incidentStatus;
    }

    public void setIncidentStatus(IncidentStatusEnum incidentStatus) {
        this.incidentStatus = incidentStatus;
    }

    public HistoricProcessInstanceQueryDto incidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident message. Exact match.")
    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    public HistoricProcessInstanceQueryDto incidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident message that the parameter is a substring of.")
    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    public HistoricProcessInstanceQueryDto startedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    public HistoricProcessInstanceQueryDto startedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    public HistoricProcessInstanceQueryDto finishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    public HistoricProcessInstanceQueryDto finishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    public HistoricProcessInstanceQueryDto executedActivityAfter(Date executedActivityAfter) {
        this.executedActivityAfter = executedActivityAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getExecutedActivityAfter() {
        return this.executedActivityAfter;
    }

    public void setExecutedActivityAfter(Date executedActivityAfter) {
        this.executedActivityAfter = executedActivityAfter;
    }

    public HistoricProcessInstanceQueryDto executedActivityBefore(Date executedActivityBefore) {
        this.executedActivityBefore = executedActivityBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getExecutedActivityBefore() {
        return this.executedActivityBefore;
    }

    public void setExecutedActivityBefore(Date executedActivityBefore) {
        this.executedActivityBefore = executedActivityBefore;
    }

    public HistoricProcessInstanceQueryDto executedJobAfter(Date executedJobAfter) {
        this.executedJobAfter = executedJobAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getExecutedJobAfter() {
        return this.executedJobAfter;
    }

    public void setExecutedJobAfter(Date executedJobAfter) {
        this.executedJobAfter = executedJobAfter;
    }

    public HistoricProcessInstanceQueryDto executedJobBefore(Date executedJobBefore) {
        this.executedJobBefore = executedJobBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getExecutedJobBefore() {
        return this.executedJobBefore;
    }

    public void setExecutedJobBefore(Date executedJobBefore) {
        this.executedJobBefore = executedJobBefore;
    }

    public HistoricProcessInstanceQueryDto startedBy(String startedBy) {
        this.startedBy = startedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include process instances that were started by the given user.")
    public String getStartedBy() {
        return this.startedBy;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public HistoricProcessInstanceQueryDto superProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.")
    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    public HistoricProcessInstanceQueryDto subProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to one process instance that has a sub process instance with the given id.")
    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }

    public void setSubProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
    }

    public HistoricProcessInstanceQueryDto superCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.")
    public String getSuperCaseInstanceId() {
        return this.superCaseInstanceId;
    }

    public void setSuperCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
    }

    public HistoricProcessInstanceQueryDto subCaseInstanceId(String subCaseInstanceId) {
        this.subCaseInstanceId = subCaseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to one process instance that has a sub case instance with the given id.")
    public String getSubCaseInstanceId() {
        return this.subCaseInstanceId;
    }

    public void setSubCaseInstanceId(String subCaseInstanceId) {
        this.subCaseInstanceId = subCaseInstanceId;
    }

    public HistoricProcessInstanceQueryDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricProcessInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricProcessInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of `Strings`")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricProcessInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic process instances which belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricProcessInstanceQueryDto executedActivityIdIn(List<String> executedActivityIdIn) {
        this.executedActivityIdIn = executedActivityIdIn;
        return this;
    }

    public HistoricProcessInstanceQueryDto addExecutedActivityIdInItem(String executedActivityIdInItem) {
        if (this.executedActivityIdIn == null) {
            this.executedActivityIdIn = new ArrayList<String>();
        }
        this.executedActivityIdIn.add(executedActivityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that executed an activity with one of given ids. Must be a JSON array of `Strings`")
    public List<String> getExecutedActivityIdIn() {
        return this.executedActivityIdIn;
    }

    public void setExecutedActivityIdIn(List<String> executedActivityIdIn) {
        this.executedActivityIdIn = executedActivityIdIn;
    }

    public HistoricProcessInstanceQueryDto activeActivityIdIn(List<String> activeActivityIdIn) {
        this.activeActivityIdIn = activeActivityIdIn;
        return this;
    }

    public HistoricProcessInstanceQueryDto addActiveActivityIdInItem(String activeActivityIdInItem) {
        if (this.activeActivityIdIn == null) {
            this.activeActivityIdIn = new ArrayList<String>();
        }
        this.activeActivityIdIn.add(activeActivityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that have an active activity with one of given ids. Must be a JSON array of `Strings`")
    public List<String> getActiveActivityIdIn() {
        return this.activeActivityIdIn;
    }

    public void setActiveActivityIdIn(List<String> activeActivityIdIn) {
        this.activeActivityIdIn = activeActivityIdIn;
    }

    public HistoricProcessInstanceQueryDto active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that are active.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public HistoricProcessInstanceQueryDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that are suspended.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public HistoricProcessInstanceQueryDto completed(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that are completed.")
    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public HistoricProcessInstanceQueryDto externallyTerminated(Boolean externallyTerminated) {
        this.externallyTerminated = externallyTerminated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that are externallyTerminated.")
    public Boolean getExternallyTerminated() {
        return this.externallyTerminated;
    }

    public void setExternallyTerminated(Boolean externallyTerminated) {
        this.externallyTerminated = externallyTerminated;
    }

    public HistoricProcessInstanceQueryDto internallyTerminated(Boolean internallyTerminated) {
        this.internallyTerminated = internallyTerminated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that are internallyTerminated.")
    public Boolean getInternallyTerminated() {
        return this.internallyTerminated;
    }

    public void setInternallyTerminated(Boolean internallyTerminated) {
        this.internallyTerminated = internallyTerminated;
    }

    public HistoricProcessInstanceQueryDto variables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
        return this;
    }

    public HistoricProcessInstanceQueryDto addVariablesItem(VariableQueryParameterDto variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<VariableQueryParameterDto>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array to only include process instances that have/had variables with certain values. The array consists of objects with the three properties `name`, `operator` and `value`. `name` (`String`) is the variable name, `operator` (`String`) is the comparison operator to be used and `value` the variable value.  Value may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. ")
    public List<VariableQueryParameterDto> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    public HistoricProcessInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match all variable names provided in variables case-insensitively. If set to `true` variableName and variablename are treated as equal.")
    public Boolean getVariableNamesIgnoreCase() {
        return this.variableNamesIgnoreCase;
    }

    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    public HistoricProcessInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match all variable values provided in variables case-insensitively. If set to `true` variableValue and variablevalue are treated as equal.")
    public Boolean getVariableValuesIgnoreCase() {
        return this.variableValuesIgnoreCase;
    }

    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    public HistoricProcessInstanceQueryDto orQueries(List<HistoricProcessInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
        return this;
    }

    public HistoricProcessInstanceQueryDto addOrQueriesItem(HistoricProcessInstanceQueryDto orQueriesItem) {
        if (this.orQueries == null) {
            this.orQueries = new ArrayList<HistoricProcessInstanceQueryDto>();
        }
        this.orQueries.add(orQueriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array of nested historic process instance queries with OR semantics.  A process instance matches a nested query if it fulfills at least one of the query's predicates.  With multiple nested queries, a process instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All process instance query properties can be used except for: `sorting`  See the [User Guide](https://docs.camunda.org/manual/7.18/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.")
    public List<HistoricProcessInstanceQueryDto> getOrQueries() {
        return this.orQueries;
    }

    public void setOrQueries(List<HistoricProcessInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
    }

    public HistoricProcessInstanceQueryDto sorting(List<HistoricProcessInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public HistoricProcessInstanceQueryDto addSortingItem(HistoricProcessInstanceQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<HistoricProcessInstanceQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply sorting of the result")
    public List<HistoricProcessInstanceQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<HistoricProcessInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto = (HistoricProcessInstanceQueryDto)o;
        return Objects.equals(this.processInstanceId, historicProcessInstanceQueryDto.processInstanceId) && Objects.equals(this.processInstanceIds, historicProcessInstanceQueryDto.processInstanceIds) && Objects.equals(this.processDefinitionId, historicProcessInstanceQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, historicProcessInstanceQueryDto.processDefinitionKey) && Objects.equals(this.processDefinitionKeyIn, historicProcessInstanceQueryDto.processDefinitionKeyIn) && Objects.equals(this.processDefinitionName, historicProcessInstanceQueryDto.processDefinitionName) && Objects.equals(this.processDefinitionNameLike, historicProcessInstanceQueryDto.processDefinitionNameLike) && Objects.equals(this.processDefinitionKeyNotIn, historicProcessInstanceQueryDto.processDefinitionKeyNotIn) && Objects.equals(this.processInstanceBusinessKey, historicProcessInstanceQueryDto.processInstanceBusinessKey) && Objects.equals(this.processInstanceBusinessKeyIn, historicProcessInstanceQueryDto.processInstanceBusinessKeyIn) && Objects.equals(this.processInstanceBusinessKeyLike, historicProcessInstanceQueryDto.processInstanceBusinessKeyLike) && Objects.equals(this.rootProcessInstances, historicProcessInstanceQueryDto.rootProcessInstances) && Objects.equals(this.finished, historicProcessInstanceQueryDto.finished) && Objects.equals(this.unfinished, historicProcessInstanceQueryDto.unfinished) && Objects.equals(this.withIncidents, historicProcessInstanceQueryDto.withIncidents) && Objects.equals(this.withRootIncidents, historicProcessInstanceQueryDto.withRootIncidents) && Objects.equals(this.incidentType, historicProcessInstanceQueryDto.incidentType) && Objects.equals((Object)this.incidentStatus, (Object)historicProcessInstanceQueryDto.incidentStatus) && Objects.equals(this.incidentMessage, historicProcessInstanceQueryDto.incidentMessage) && Objects.equals(this.incidentMessageLike, historicProcessInstanceQueryDto.incidentMessageLike) && Objects.equals(this.startedBefore, historicProcessInstanceQueryDto.startedBefore) && Objects.equals(this.startedAfter, historicProcessInstanceQueryDto.startedAfter) && Objects.equals(this.finishedBefore, historicProcessInstanceQueryDto.finishedBefore) && Objects.equals(this.finishedAfter, historicProcessInstanceQueryDto.finishedAfter) && Objects.equals(this.executedActivityAfter, historicProcessInstanceQueryDto.executedActivityAfter) && Objects.equals(this.executedActivityBefore, historicProcessInstanceQueryDto.executedActivityBefore) && Objects.equals(this.executedJobAfter, historicProcessInstanceQueryDto.executedJobAfter) && Objects.equals(this.executedJobBefore, historicProcessInstanceQueryDto.executedJobBefore) && Objects.equals(this.startedBy, historicProcessInstanceQueryDto.startedBy) && Objects.equals(this.superProcessInstanceId, historicProcessInstanceQueryDto.superProcessInstanceId) && Objects.equals(this.subProcessInstanceId, historicProcessInstanceQueryDto.subProcessInstanceId) && Objects.equals(this.superCaseInstanceId, historicProcessInstanceQueryDto.superCaseInstanceId) && Objects.equals(this.subCaseInstanceId, historicProcessInstanceQueryDto.subCaseInstanceId) && Objects.equals(this.caseInstanceId, historicProcessInstanceQueryDto.caseInstanceId) && Objects.equals(this.tenantIdIn, historicProcessInstanceQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicProcessInstanceQueryDto.withoutTenantId) && Objects.equals(this.executedActivityIdIn, historicProcessInstanceQueryDto.executedActivityIdIn) && Objects.equals(this.activeActivityIdIn, historicProcessInstanceQueryDto.activeActivityIdIn) && Objects.equals(this.active, historicProcessInstanceQueryDto.active) && Objects.equals(this.suspended, historicProcessInstanceQueryDto.suspended) && Objects.equals(this.completed, historicProcessInstanceQueryDto.completed) && Objects.equals(this.externallyTerminated, historicProcessInstanceQueryDto.externallyTerminated) && Objects.equals(this.internallyTerminated, historicProcessInstanceQueryDto.internallyTerminated) && Objects.equals(this.variables, historicProcessInstanceQueryDto.variables) && Objects.equals(this.variableNamesIgnoreCase, historicProcessInstanceQueryDto.variableNamesIgnoreCase) && Objects.equals(this.variableValuesIgnoreCase, historicProcessInstanceQueryDto.variableValuesIgnoreCase) && Objects.equals(this.orQueries, historicProcessInstanceQueryDto.orQueries) && Objects.equals(this.sorting, historicProcessInstanceQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.processInstanceId, this.processInstanceIds, this.processDefinitionId, this.processDefinitionKey, this.processDefinitionKeyIn, this.processDefinitionName, this.processDefinitionNameLike, this.processDefinitionKeyNotIn, this.processInstanceBusinessKey, this.processInstanceBusinessKeyIn, this.processInstanceBusinessKeyLike, this.rootProcessInstances, this.finished, this.unfinished, this.withIncidents, this.withRootIncidents, this.incidentType, this.incidentStatus, this.incidentMessage, this.incidentMessageLike, this.startedBefore, this.startedAfter, this.finishedBefore, this.finishedAfter, this.executedActivityAfter, this.executedActivityBefore, this.executedJobAfter, this.executedJobBefore, this.startedBy, this.superProcessInstanceId, this.subProcessInstanceId, this.superCaseInstanceId, this.subCaseInstanceId, this.caseInstanceId, this.tenantIdIn, this.withoutTenantId, this.executedActivityIdIn, this.activeActivityIdIn, this.active, this.suspended, this.completed, this.externallyTerminated, this.internallyTerminated, this.variables, this.variableNamesIgnoreCase, this.variableValuesIgnoreCase, this.orQueries, this.sorting});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricProcessInstanceQueryDto {\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionKeyIn: ").append(this.toIndentedString(this.processDefinitionKeyIn)).append("\n");
        sb.append("    processDefinitionName: ").append(this.toIndentedString(this.processDefinitionName)).append("\n");
        sb.append("    processDefinitionNameLike: ").append(this.toIndentedString(this.processDefinitionNameLike)).append("\n");
        sb.append("    processDefinitionKeyNotIn: ").append(this.toIndentedString(this.processDefinitionKeyNotIn)).append("\n");
        sb.append("    processInstanceBusinessKey: ").append(this.toIndentedString(this.processInstanceBusinessKey)).append("\n");
        sb.append("    processInstanceBusinessKeyIn: ").append(this.toIndentedString(this.processInstanceBusinessKeyIn)).append("\n");
        sb.append("    processInstanceBusinessKeyLike: ").append(this.toIndentedString(this.processInstanceBusinessKeyLike)).append("\n");
        sb.append("    rootProcessInstances: ").append(this.toIndentedString(this.rootProcessInstances)).append("\n");
        sb.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        sb.append("    unfinished: ").append(this.toIndentedString(this.unfinished)).append("\n");
        sb.append("    withIncidents: ").append(this.toIndentedString(this.withIncidents)).append("\n");
        sb.append("    withRootIncidents: ").append(this.toIndentedString(this.withRootIncidents)).append("\n");
        sb.append("    incidentType: ").append(this.toIndentedString(this.incidentType)).append("\n");
        sb.append("    incidentStatus: ").append(this.toIndentedString((Object)this.incidentStatus)).append("\n");
        sb.append("    incidentMessage: ").append(this.toIndentedString(this.incidentMessage)).append("\n");
        sb.append("    incidentMessageLike: ").append(this.toIndentedString(this.incidentMessageLike)).append("\n");
        sb.append("    startedBefore: ").append(this.toIndentedString(this.startedBefore)).append("\n");
        sb.append("    startedAfter: ").append(this.toIndentedString(this.startedAfter)).append("\n");
        sb.append("    finishedBefore: ").append(this.toIndentedString(this.finishedBefore)).append("\n");
        sb.append("    finishedAfter: ").append(this.toIndentedString(this.finishedAfter)).append("\n");
        sb.append("    executedActivityAfter: ").append(this.toIndentedString(this.executedActivityAfter)).append("\n");
        sb.append("    executedActivityBefore: ").append(this.toIndentedString(this.executedActivityBefore)).append("\n");
        sb.append("    executedJobAfter: ").append(this.toIndentedString(this.executedJobAfter)).append("\n");
        sb.append("    executedJobBefore: ").append(this.toIndentedString(this.executedJobBefore)).append("\n");
        sb.append("    startedBy: ").append(this.toIndentedString(this.startedBy)).append("\n");
        sb.append("    superProcessInstanceId: ").append(this.toIndentedString(this.superProcessInstanceId)).append("\n");
        sb.append("    subProcessInstanceId: ").append(this.toIndentedString(this.subProcessInstanceId)).append("\n");
        sb.append("    superCaseInstanceId: ").append(this.toIndentedString(this.superCaseInstanceId)).append("\n");
        sb.append("    subCaseInstanceId: ").append(this.toIndentedString(this.subCaseInstanceId)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    executedActivityIdIn: ").append(this.toIndentedString(this.executedActivityIdIn)).append("\n");
        sb.append("    activeActivityIdIn: ").append(this.toIndentedString(this.activeActivityIdIn)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    externallyTerminated: ").append(this.toIndentedString(this.externallyTerminated)).append("\n");
        sb.append("    internallyTerminated: ").append(this.toIndentedString(this.internallyTerminated)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    variableNamesIgnoreCase: ").append(this.toIndentedString(this.variableNamesIgnoreCase)).append("\n");
        sb.append("    variableValuesIgnoreCase: ").append(this.toIndentedString(this.variableValuesIgnoreCase)).append("\n");
        sb.append("    orQueries: ").append(this.toIndentedString(this.orQueries)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IncidentStatusEnum {
        OPEN("open"),
        RESOLVED("resolved");

        private String value;

        private IncidentStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IncidentStatusEnum fromValue(String value) {
            for (IncidentStatusEnum b : IncidentStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<IncidentStatusEnum> {
            public void write(JsonWriter jsonWriter, IncidentStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IncidentStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IncidentStatusEnum.fromValue(value);
            }
        }
    }
}

