/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoryCleanupConfigurationDto {
    public static final String SERIALIZED_NAME_BATCH_WINDOW_START_TIME = "batchWindowStartTime";
    @SerializedName(value="batchWindowStartTime")
    private Date batchWindowStartTime;
    public static final String SERIALIZED_NAME_BATCH_WINDOW_END_TIME = "batchWindowEndTime";
    @SerializedName(value="batchWindowEndTime")
    private Date batchWindowEndTime;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;

    public HistoryCleanupConfigurationDto batchWindowStartTime(Date batchWindowStartTime) {
        this.batchWindowStartTime = batchWindowStartTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Start time of the current or next batch window. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getBatchWindowStartTime() {
        return this.batchWindowStartTime;
    }

    public void setBatchWindowStartTime(Date batchWindowStartTime) {
        this.batchWindowStartTime = batchWindowStartTime;
    }

    public HistoryCleanupConfigurationDto batchWindowEndTime(Date batchWindowEndTime) {
        this.batchWindowEndTime = batchWindowEndTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="End time of the current or next batch window. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getBatchWindowEndTime() {
        return this.batchWindowEndTime;
    }

    public void setBatchWindowEndTime(Date batchWindowEndTime) {
        this.batchWindowEndTime = batchWindowEndTime;
    }

    public HistoryCleanupConfigurationDto enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the engine node participates in history cleanup or not. The default is `true`. Participation can be disabled via [Process Engine Configuration](https://docs.camunda.org/manual/7.18/reference/deployment-descriptors/tags/process-engine/#history-cleanup-enabled).  For more details, see [Cleanup Execution Participation per Node](https://docs.camunda.org/manual/7.18/user-guide/process-engine/history/#cleanup-execution-participation-per-node).")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryCleanupConfigurationDto historyCleanupConfigurationDto = (HistoryCleanupConfigurationDto)o;
        return Objects.equals(this.batchWindowStartTime, historyCleanupConfigurationDto.batchWindowStartTime) && Objects.equals(this.batchWindowEndTime, historyCleanupConfigurationDto.batchWindowEndTime) && Objects.equals(this.enabled, historyCleanupConfigurationDto.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.batchWindowStartTime, this.batchWindowEndTime, this.enabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryCleanupConfigurationDto {\n");
        sb.append("    batchWindowStartTime: ").append(this.toIndentedString(this.batchWindowStartTime)).append("\n");
        sb.append("    batchWindowEndTime: ").append(this.toIndentedString(this.batchWindowEndTime)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

