/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class IncidentDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_INCIDENT_TIMESTAMP = "incidentTimestamp";
    @SerializedName(value="incidentTimestamp")
    private Date incidentTimestamp;
    public static final String SERIALIZED_NAME_INCIDENT_TYPE = "incidentType";
    @SerializedName(value="incidentType")
    private String incidentType;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_FAILED_ACTIVITY_ID = "failedActivityId";
    @SerializedName(value="failedActivityId")
    private String failedActivityId;
    public static final String SERIALIZED_NAME_CAUSE_INCIDENT_ID = "causeIncidentId";
    @SerializedName(value="causeIncidentId")
    private String causeIncidentId;
    public static final String SERIALIZED_NAME_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
    @SerializedName(value="rootCauseIncidentId")
    private String rootCauseIncidentId;
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private String _configuration;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_INCIDENT_MESSAGE = "incidentMessage";
    @SerializedName(value="incidentMessage")
    private String incidentMessage;
    public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
    @SerializedName(value="jobDefinitionId")
    private String jobDefinitionId;
    public static final String SERIALIZED_NAME_ANNOTATION = "annotation";
    @SerializedName(value="annotation")
    private String annotation;

    public IncidentDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the incident.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IncidentDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition this incident is associated with.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public IncidentDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance this incident is associated with.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public IncidentDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the execution this incident is associated with.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public IncidentDto incidentTimestamp(Date incidentTimestamp) {
        this.incidentTimestamp = incidentTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time this incident happened. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getIncidentTimestamp() {
        return this.incidentTimestamp;
    }

    public void setIncidentTimestamp(Date incidentTimestamp) {
        this.incidentTimestamp = incidentTimestamp;
    }

    public IncidentDto incidentType(String incidentType) {
        this.incidentType = incidentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of incident, for example: `failedJobs` will be returned in case of an incident which identified a failed job during the execution of a process instance. See the [User Guide](https://docs.camunda.org/manual/7.18/user-guide/process-engine/incidents/#incident-types) for a list of incident types.")
    public String getIncidentType() {
        return this.incidentType;
    }

    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    public IncidentDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity this incident is associated with.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public IncidentDto failedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity on which the last exception occurred.")
    public String getFailedActivityId() {
        return this.failedActivityId;
    }

    public void setFailedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
    }

    public IncidentDto causeIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the associated cause incident which has been triggered.")
    public String getCauseIncidentId() {
        return this.causeIncidentId;
    }

    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    public IncidentDto rootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the associated root cause incident which has been triggered.")
    public String getRootCauseIncidentId() {
        return this.rootCauseIncidentId;
    }

    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    public IncidentDto _configuration(String _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payload of this incident.")
    public String getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(String _configuration) {
        this._configuration = _configuration;
    }

    public IncidentDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant this incident is associated with.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public IncidentDto incidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The message of this incident.")
    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    public IncidentDto jobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The job definition id the incident is associated with.")
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public IncidentDto annotation(String annotation) {
        this.annotation = annotation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The annotation set to the incident.")
    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentDto incidentDto = (IncidentDto)o;
        return Objects.equals(this.id, incidentDto.id) && Objects.equals(this.processDefinitionId, incidentDto.processDefinitionId) && Objects.equals(this.processInstanceId, incidentDto.processInstanceId) && Objects.equals(this.executionId, incidentDto.executionId) && Objects.equals(this.incidentTimestamp, incidentDto.incidentTimestamp) && Objects.equals(this.incidentType, incidentDto.incidentType) && Objects.equals(this.activityId, incidentDto.activityId) && Objects.equals(this.failedActivityId, incidentDto.failedActivityId) && Objects.equals(this.causeIncidentId, incidentDto.causeIncidentId) && Objects.equals(this.rootCauseIncidentId, incidentDto.rootCauseIncidentId) && Objects.equals(this._configuration, incidentDto._configuration) && Objects.equals(this.tenantId, incidentDto.tenantId) && Objects.equals(this.incidentMessage, incidentDto.incidentMessage) && Objects.equals(this.jobDefinitionId, incidentDto.jobDefinitionId) && Objects.equals(this.annotation, incidentDto.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.processDefinitionId, this.processInstanceId, this.executionId, this.incidentTimestamp, this.incidentType, this.activityId, this.failedActivityId, this.causeIncidentId, this.rootCauseIncidentId, this._configuration, this.tenantId, this.incidentMessage, this.jobDefinitionId, this.annotation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    incidentTimestamp: ").append(this.toIndentedString(this.incidentTimestamp)).append("\n");
        sb.append("    incidentType: ").append(this.toIndentedString(this.incidentType)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    failedActivityId: ").append(this.toIndentedString(this.failedActivityId)).append("\n");
        sb.append("    causeIncidentId: ").append(this.toIndentedString(this.causeIncidentId)).append("\n");
        sb.append("    rootCauseIncidentId: ").append(this.toIndentedString(this.rootCauseIncidentId)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    incidentMessage: ").append(this.toIndentedString(this.incidentMessage)).append("\n");
        sb.append("    jobDefinitionId: ").append(this.toIndentedString(this.jobDefinitionId)).append("\n");
        sb.append("    annotation: ").append(this.toIndentedString(this.annotation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

