/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class JobDefinitionsSuspensionStateDto {
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    @SerializedName(value="processDefinitionTenantId")
    private String processDefinitionTenantId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_WITHOUT_TENANT_ID = "processDefinitionWithoutTenantId";
    @SerializedName(value="processDefinitionWithoutTenantId")
    private Boolean processDefinitionWithoutTenantId;
    public static final String SERIALIZED_NAME_INCLUDE_JOBS = "includeJobs";
    @SerializedName(value="includeJobs")
    private Boolean includeJobs;
    public static final String SERIALIZED_NAME_EXECUTION_DATE = "executionDate";
    @SerializedName(value="executionDate")
    private String executionDate;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;

    public JobDefinitionsSuspensionStateDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process definition id of the job definitions to activate or suspend.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public JobDefinitionsSuspensionStateDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process definition key of the job definitions to activate or suspend.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public JobDefinitionsSuspensionStateDto processDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only activate or suspend job definitions of a process definition which belongs to a tenant with the given id.  Note that this parameter will only be considered  in combination with `processDefinitionKey`.")
    public String getProcessDefinitionTenantId() {
        return this.processDefinitionTenantId;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public JobDefinitionsSuspensionStateDto processDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only activate or suspend job definitions of a process definition which belongs to no tenant. Value may only be `true`, as `false` is the default behavior.  Note that this parameter will only be considered  in combination with `processDefinitionKey`.")
    public Boolean getProcessDefinitionWithoutTenantId() {
        return this.processDefinitionWithoutTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    public JobDefinitionsSuspensionStateDto includeJobs(Boolean includeJobs) {
        this.includeJobs = includeJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A `Boolean` value which indicates whether to activate or suspend also all jobs of the referenced job definitions. When the value is set to `true`, all jobs of the provided job definitions will be activated or suspended and when the value is set to `false`, the suspension state of all jobs of the provided job definitions will not be updated.")
    public Boolean getIncludeJobs() {
        return this.includeJobs;
    }

    public void setIncludeJobs(Boolean includeJobs) {
        this.includeJobs = includeJobs;
    }

    public JobDefinitionsSuspensionStateDto executionDate(String executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which the referenced job definitions will be activated or suspended. If null, the suspension state of the given job definitions is updated immediately. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public String getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public JobDefinitionsSuspensionStateDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean value which indicates whether to activate or suspend a given instance  (e.g. process instance, job, job definition, or batch). When the value is set to true,  the given instance will be suspended and when the value is set to false,  the given instance will be activated.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto = (JobDefinitionsSuspensionStateDto)o;
        return Objects.equals(this.processDefinitionId, jobDefinitionsSuspensionStateDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, jobDefinitionsSuspensionStateDto.processDefinitionKey) && Objects.equals(this.processDefinitionTenantId, jobDefinitionsSuspensionStateDto.processDefinitionTenantId) && Objects.equals(this.processDefinitionWithoutTenantId, jobDefinitionsSuspensionStateDto.processDefinitionWithoutTenantId) && Objects.equals(this.includeJobs, jobDefinitionsSuspensionStateDto.includeJobs) && Objects.equals(this.executionDate, jobDefinitionsSuspensionStateDto.executionDate) && Objects.equals(this.suspended, jobDefinitionsSuspensionStateDto.suspended);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionId, this.processDefinitionKey, this.processDefinitionTenantId, this.processDefinitionWithoutTenantId, this.includeJobs, this.executionDate, this.suspended);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobDefinitionsSuspensionStateDto {\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionTenantId: ").append(this.toIndentedString(this.processDefinitionTenantId)).append("\n");
        sb.append("    processDefinitionWithoutTenantId: ").append(this.toIndentedString(this.processDefinitionWithoutTenantId)).append("\n");
        sb.append("    includeJobs: ").append(this.toIndentedString(this.includeJobs)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

