/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class ProcessDefinitionDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private String category;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    private String resource;
    public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
    @SerializedName(value="deploymentId")
    private String deploymentId;
    public static final String SERIALIZED_NAME_DIAGRAM = "diagram";
    @SerializedName(value="diagram")
    private String diagram;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_VERSION_TAG = "versionTag";
    @SerializedName(value="versionTag")
    private String versionTag;
    public static final String SERIALIZED_NAME_HISTORY_TIME_TO_LIVE = "historyTimeToLive";
    @SerializedName(value="historyTimeToLive")
    private Integer historyTimeToLive;
    public static final String SERIALIZED_NAME_STARTABLE_IN_TASKLIST = "startableInTasklist";
    @SerializedName(value="startableInTasklist")
    private Boolean startableInTasklist;

    public ProcessDefinitionDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProcessDefinitionDto key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition, i.e., the id of the BPMN 2.0 XML process definition.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ProcessDefinitionDto category(String category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The category of the process definition.")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ProcessDefinitionDto description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The description of the process definition.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProcessDefinitionDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the process definition.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessDefinitionDto version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version of the process definition that the engine assigned to it.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ProcessDefinitionDto resource(String resource) {
        this.resource = resource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file name of the process definition.")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public ProcessDefinitionDto deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The deployment id of the process definition.")
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public ProcessDefinitionDto diagram(String diagram) {
        this.diagram = diagram;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file name of the process definition diagram, if it exists.")
    public String getDiagram() {
        return this.diagram;
    }

    public void setDiagram(String diagram) {
        this.diagram = diagram;
    }

    public ProcessDefinitionDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether the definition is suspended or not.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public ProcessDefinitionDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the process definition.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public ProcessDefinitionDto versionTag(String versionTag) {
        this.versionTag = versionTag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version tag of the process definition.")
    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    public ProcessDefinitionDto historyTimeToLive(Integer historyTimeToLive) {
        this.historyTimeToLive = historyTimeToLive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="History time to live value of the process definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.18/user-guide/process-engine/history/#history-cleanup).")
    public Integer getHistoryTimeToLive() {
        return this.historyTimeToLive;
    }

    public void setHistoryTimeToLive(Integer historyTimeToLive) {
        this.historyTimeToLive = historyTimeToLive;
    }

    public ProcessDefinitionDto startableInTasklist(Boolean startableInTasklist) {
        this.startableInTasklist = startableInTasklist;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether the process definition is startable in Tasklist or not.")
    public Boolean getStartableInTasklist() {
        return this.startableInTasklist;
    }

    public void setStartableInTasklist(Boolean startableInTasklist) {
        this.startableInTasklist = startableInTasklist;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessDefinitionDto processDefinitionDto = (ProcessDefinitionDto)o;
        return Objects.equals(this.id, processDefinitionDto.id) && Objects.equals(this.key, processDefinitionDto.key) && Objects.equals(this.category, processDefinitionDto.category) && Objects.equals(this.description, processDefinitionDto.description) && Objects.equals(this.name, processDefinitionDto.name) && Objects.equals(this.version, processDefinitionDto.version) && Objects.equals(this.resource, processDefinitionDto.resource) && Objects.equals(this.deploymentId, processDefinitionDto.deploymentId) && Objects.equals(this.diagram, processDefinitionDto.diagram) && Objects.equals(this.suspended, processDefinitionDto.suspended) && Objects.equals(this.tenantId, processDefinitionDto.tenantId) && Objects.equals(this.versionTag, processDefinitionDto.versionTag) && Objects.equals(this.historyTimeToLive, processDefinitionDto.historyTimeToLive) && Objects.equals(this.startableInTasklist, processDefinitionDto.startableInTasklist);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.category, this.description, this.name, this.version, this.resource, this.deploymentId, this.diagram, this.suspended, this.tenantId, this.versionTag, this.historyTimeToLive, this.startableInTasklist);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessDefinitionDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    deploymentId: ").append(this.toIndentedString(this.deploymentId)).append("\n");
        sb.append("    diagram: ").append(this.toIndentedString(this.diagram)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    versionTag: ").append(this.toIndentedString(this.versionTag)).append("\n");
        sb.append("    historyTimeToLive: ").append(this.toIndentedString(this.historyTimeToLive)).append("\n");
        sb.append("    startableInTasklist: ").append(this.toIndentedString(this.startableInTasklist)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

