/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.IncidentStatisticsResultDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDto;

public class ProcessDefinitionStatisticsResultDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INSTANCES = "instances";
    @SerializedName(value="instances")
    private Integer instances;
    public static final String SERIALIZED_NAME_FAILED_JOBS = "failedJobs";
    @SerializedName(value="failedJobs")
    private Integer failedJobs;
    public static final String SERIALIZED_NAME_INCIDENTS = "incidents";
    @SerializedName(value="incidents")
    private List<IncidentStatisticsResultDto> incidents = null;
    public static final String SERIALIZED_NAME_DEFINITION = "definition";
    @SerializedName(value="definition")
    private ProcessDefinitionDto definition;

    public ProcessDefinitionStatisticsResultDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition the results are aggregated for.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProcessDefinitionStatisticsResultDto instances(Integer instances) {
        this.instances = instances;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of running process instances of this process definition.")
    public Integer getInstances() {
        return this.instances;
    }

    public void setInstances(Integer instances) {
        this.instances = instances;
    }

    public ProcessDefinitionStatisticsResultDto failedJobs(Integer failedJobs) {
        this.failedJobs = failedJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of failed jobs for the running instances. **Note**: Will be `0` (not `null`), if failed jobs were excluded.")
    public Integer getFailedJobs() {
        return this.failedJobs;
    }

    public void setFailedJobs(Integer failedJobs) {
        this.failedJobs = failedJobs;
    }

    public ProcessDefinitionStatisticsResultDto incidents(List<IncidentStatisticsResultDto> incidents) {
        this.incidents = incidents;
        return this;
    }

    public ProcessDefinitionStatisticsResultDto addIncidentsItem(IncidentStatisticsResultDto incidentsItem) {
        if (this.incidents == null) {
            this.incidents = new ArrayList<IncidentStatisticsResultDto>();
        }
        this.incidents.add(incidentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Each item in the resulting array is an object which contains `incidentType` and `incidentCount`. **Note**: Will be an empty array, if `incidents` or `incidentsForType` were excluded. Furthermore, the array will be also empty if no incidents were found.")
    public List<IncidentStatisticsResultDto> getIncidents() {
        return this.incidents;
    }

    public void setIncidents(List<IncidentStatisticsResultDto> incidents) {
        this.incidents = incidents;
    }

    public ProcessDefinitionStatisticsResultDto definition(ProcessDefinitionDto definition) {
        this.definition = definition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessDefinitionDto getDefinition() {
        return this.definition;
    }

    public void setDefinition(ProcessDefinitionDto definition) {
        this.definition = definition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessDefinitionStatisticsResultDto processDefinitionStatisticsResultDto = (ProcessDefinitionStatisticsResultDto)o;
        return Objects.equals(this.id, processDefinitionStatisticsResultDto.id) && Objects.equals(this.instances, processDefinitionStatisticsResultDto.instances) && Objects.equals(this.failedJobs, processDefinitionStatisticsResultDto.failedJobs) && Objects.equals(this.incidents, processDefinitionStatisticsResultDto.incidents) && Objects.equals(this.definition, processDefinitionStatisticsResultDto.definition);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.instances, this.failedJobs, this.incidents, this.definition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessDefinitionStatisticsResultDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    instances: ").append(this.toIndentedString(this.instances)).append("\n");
        sb.append("    failedJobs: ").append(this.toIndentedString(this.failedJobs)).append("\n");
        sb.append("    incidents: ").append(this.toIndentedString(this.incidents)).append("\n");
        sb.append("    definition: ").append(this.toIndentedString(this.definition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

