/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class ProcessDefinitionSuspensionStateDto {
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_INCLUDE_PROCESS_INSTANCES = "includeProcessInstances";
    @SerializedName(value="includeProcessInstances")
    private Boolean includeProcessInstances;
    public static final String SERIALIZED_NAME_EXECUTION_DATE = "executionDate";
    @SerializedName(value="executionDate")
    private Date executionDate;

    public ProcessDefinitionSuspensionStateDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A `Boolean` value which indicates whether to activate or suspend all process definitions with the given key. When the value is set to `true`, all process definitions with the given key will be suspended and when the value is set to `false`, all process definitions with the given key will be activated.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public ProcessDefinitionSuspensionStateDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definitions to activate or suspend.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ProcessDefinitionSuspensionStateDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definitions to activate or suspend.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public ProcessDefinitionSuspensionStateDto includeProcessInstances(Boolean includeProcessInstances) {
        this.includeProcessInstances = includeProcessInstances;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A `Boolean` value which indicates whether to activate or suspend also all process instances of  the process definitions with the given key. When the value is set to `true`, all process instances of the process definitions with the given key will be activated or suspended and when the value is set to `false`, the suspension state of  all process instances of the process definitions with the given key will not be updated.")
    public Boolean getIncludeProcessInstances() {
        return this.includeProcessInstances;
    }

    public void setIncludeProcessInstances(Boolean includeProcessInstances) {
        this.includeProcessInstances = includeProcessInstances;
    }

    public ProcessDefinitionSuspensionStateDto executionDate(Date executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which all process definitions with the given key will be activated or suspended. If `null`, the suspension state of all process definitions with the given key is updated immediately. By [default](https://docs.camunda.org/manual/7.18/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto = (ProcessDefinitionSuspensionStateDto)o;
        return Objects.equals(this.suspended, processDefinitionSuspensionStateDto.suspended) && Objects.equals(this.processDefinitionId, processDefinitionSuspensionStateDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, processDefinitionSuspensionStateDto.processDefinitionKey) && Objects.equals(this.includeProcessInstances, processDefinitionSuspensionStateDto.includeProcessInstances) && Objects.equals(this.executionDate, processDefinitionSuspensionStateDto.executionDate);
    }

    public int hashCode() {
        return Objects.hash(this.suspended, this.processDefinitionId, this.processDefinitionKey, this.includeProcessInstances, this.executionDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessDefinitionSuspensionStateDto {\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    includeProcessInstances: ").append(this.toIndentedString(this.includeProcessInstances)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

