/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ProcessInstanceModificationInstructionDto;

public class ProcessInstanceModificationDto {
    public static final String SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
    @SerializedName(value="skipCustomListeners")
    private Boolean skipCustomListeners;
    public static final String SERIALIZED_NAME_SKIP_IO_MAPPINGS = "skipIoMappings";
    @SerializedName(value="skipIoMappings")
    private Boolean skipIoMappings;
    public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
    @SerializedName(value="instructions")
    private List<ProcessInstanceModificationInstructionDto> instructions = null;
    public static final String SERIALIZED_NAME_ANNOTATION = "annotation";
    @SerializedName(value="annotation")
    private String annotation;

    public ProcessInstanceModificationDto skipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip execution listener invocation for activities that are started or ended as part of this request.")
    public Boolean getSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public void setSkipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }

    public ProcessInstanceModificationDto skipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.18/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request.")
    public Boolean getSkipIoMappings() {
        return this.skipIoMappings;
    }

    public void setSkipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
    }

    public ProcessInstanceModificationDto instructions(List<ProcessInstanceModificationInstructionDto> instructions) {
        this.instructions = instructions;
        return this;
    }

    public ProcessInstanceModificationDto addInstructionsItem(ProcessInstanceModificationInstructionDto instructionsItem) {
        if (this.instructions == null) {
            this.instructions = new ArrayList<ProcessInstanceModificationInstructionDto>();
        }
        this.instructions.add(instructionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JSON array of modification instructions. The instructions are executed in the order they are in.")
    public List<ProcessInstanceModificationInstructionDto> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<ProcessInstanceModificationInstructionDto> instructions) {
        this.instructions = instructions;
    }

    public ProcessInstanceModificationDto annotation(String annotation) {
        this.annotation = annotation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary text annotation set by a user for auditing reasons.")
    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceModificationDto processInstanceModificationDto = (ProcessInstanceModificationDto)o;
        return Objects.equals(this.skipCustomListeners, processInstanceModificationDto.skipCustomListeners) && Objects.equals(this.skipIoMappings, processInstanceModificationDto.skipIoMappings) && Objects.equals(this.instructions, processInstanceModificationDto.instructions) && Objects.equals(this.annotation, processInstanceModificationDto.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.skipCustomListeners, this.skipIoMappings, this.instructions, this.annotation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceModificationDto {\n");
        sb.append("    skipCustomListeners: ").append(this.toIndentedString(this.skipCustomListeners)).append("\n");
        sb.append("    skipIoMappings: ").append(this.toIndentedString(this.skipIoMappings)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    annotation: ").append(this.toIndentedString(this.annotation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

