/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.TriggerVariableValueDto;

public class ProcessInstanceModificationInstructionDto {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private TriggerVariableValueDto variables = null;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_TRANSITION_ID = "transitionId";
    @SerializedName(value="transitionId")
    private String transitionId;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    @SerializedName(value="activityInstanceId")
    private String activityInstanceId;
    public static final String SERIALIZED_NAME_TRANSITION_INSTANCE_ID = "transitionInstanceId";
    @SerializedName(value="transitionInstanceId")
    private String transitionInstanceId;
    public static final String SERIALIZED_NAME_ANCESTOR_ACTIVITY_INSTANCE_ID = "ancestorActivityInstanceId";
    @SerializedName(value="ancestorActivityInstanceId")
    private String ancestorActivityInstanceId;
    public static final String SERIALIZED_NAME_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES = "cancelCurrentActiveActivityInstances";
    @SerializedName(value="cancelCurrentActiveActivityInstances")
    private Boolean cancelCurrentActiveActivityInstances;

    public ProcessInstanceModificationInstructionDto type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**Mandatory**. One of the following values: `cancel`, `startBeforeActivity`, `startAfterActivity`, `startTransition`.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ProcessInstanceModificationInstructionDto variables(TriggerVariableValueDto variables) {
        this.variables = variables;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TriggerVariableValueDto getVariables() {
        return this.variables;
    }

    public void setVariables(TriggerVariableValueDto variables) {
        this.variables = variables;
    }

    public ProcessInstanceModificationInstructionDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public ProcessInstanceModificationInstructionDto transitionId(String transitionId) {
        this.transitionId = transitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.")
    public String getTransitionId() {
        return this.transitionId;
    }

    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    public ProcessInstanceModificationInstructionDto activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of type `cancel`. Specifies the activity instance to cancel. Valid values are the activity instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.18/reference/rest/process-instance/get-activity-instances/).")
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public ProcessInstanceModificationInstructionDto transitionInstanceId(String transitionInstanceId) {
        this.transitionInstanceId = transitionInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of type `cancel`. Specifies the transition instance to cancel. Valid values are the transition instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.18/reference/rest/process-instance/get-activity-instances/).")
    public String getTransitionInstanceId() {
        return this.transitionInstanceId;
    }

    public void setTransitionInstanceId(String transitionInstanceId) {
        this.transitionInstanceId = transitionInstanceId;
    }

    public ProcessInstanceModificationInstructionDto ancestorActivityInstanceId(String ancestorActivityInstanceId) {
        this.ancestorActivityInstanceId = ancestorActivityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of type `startBeforeActivity`, `startAfterActivity`, and `startTransition`. Valid values are the activity instance IDs supplied by the Get Activity Instance request. If there are multiple parent activity instances of the targeted activity, this specifies the ancestor scope in which hierarchy the activity/transition is to be instantiated.  Example: When there are two instances of a subprocess and an activity contained in the subprocess is to be started, this parameter allows to specifiy under which subprocess instance the activity should be started.")
    public String getAncestorActivityInstanceId() {
        return this.ancestorActivityInstanceId;
    }

    public void setAncestorActivityInstanceId(String ancestorActivityInstanceId) {
        this.ancestorActivityInstanceId = ancestorActivityInstanceId;
    }

    public ProcessInstanceModificationInstructionDto cancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
        this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.")
    public Boolean getCancelCurrentActiveActivityInstances() {
        return this.cancelCurrentActiveActivityInstances;
    }

    public void setCancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
        this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceModificationInstructionDto processInstanceModificationInstructionDto = (ProcessInstanceModificationInstructionDto)o;
        return Objects.equals((Object)this.type, (Object)processInstanceModificationInstructionDto.type) && Objects.equals(this.variables, processInstanceModificationInstructionDto.variables) && Objects.equals(this.activityId, processInstanceModificationInstructionDto.activityId) && Objects.equals(this.transitionId, processInstanceModificationInstructionDto.transitionId) && Objects.equals(this.activityInstanceId, processInstanceModificationInstructionDto.activityInstanceId) && Objects.equals(this.transitionInstanceId, processInstanceModificationInstructionDto.transitionInstanceId) && Objects.equals(this.ancestorActivityInstanceId, processInstanceModificationInstructionDto.ancestorActivityInstanceId) && Objects.equals(this.cancelCurrentActiveActivityInstances, processInstanceModificationInstructionDto.cancelCurrentActiveActivityInstances);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.variables, this.activityId, this.transitionId, this.activityInstanceId, this.transitionInstanceId, this.ancestorActivityInstanceId, this.cancelCurrentActiveActivityInstances});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceModificationInstructionDto {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    transitionId: ").append(this.toIndentedString(this.transitionId)).append("\n");
        sb.append("    activityInstanceId: ").append(this.toIndentedString(this.activityInstanceId)).append("\n");
        sb.append("    transitionInstanceId: ").append(this.toIndentedString(this.transitionInstanceId)).append("\n");
        sb.append("    ancestorActivityInstanceId: ").append(this.toIndentedString(this.ancestorActivityInstanceId)).append("\n");
        sb.append("    cancelCurrentActiveActivityInstances: ").append(this.toIndentedString(this.cancelCurrentActiveActivityInstances)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CANCEL("cancel"),
        STARTBEFOREACTIVITY("startBeforeActivity"),
        STARTAFTERACTIVITY("startAfterActivity"),
        STARTTRANSITION("startTransition");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

