/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ExternalTaskQueryDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;

public class SetRetriesForExternalTasksDto {
    public static final String SERIALIZED_NAME_RETRIES = "retries";
    @SerializedName(value="retries")
    private Integer retries;
    public static final String SERIALIZED_NAME_EXTERNAL_TASK_IDS = "externalTaskIds";
    @SerializedName(value="externalTaskIds")
    private List<String> externalTaskIds = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
    @SerializedName(value="processInstanceIds")
    private List<String> processInstanceIds = null;
    public static final String SERIALIZED_NAME_EXTERNAL_TASK_QUERY = "externalTaskQuery";
    @SerializedName(value="externalTaskQuery")
    private ExternalTaskQueryDto externalTaskQuery;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
    @SerializedName(value="processInstanceQuery")
    private ProcessInstanceQueryDto processInstanceQuery;
    public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
    @SerializedName(value="historicProcessInstanceQuery")
    private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

    public SetRetriesForExternalTasksDto retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of retries to set for the external task.  Must be >= 0. If this is 0, an incident is created and the task cannot be fetched anymore unless the retries are increased again. Can not be null.")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public SetRetriesForExternalTasksDto externalTaskIds(List<String> externalTaskIds) {
        this.externalTaskIds = externalTaskIds;
        return this;
    }

    public SetRetriesForExternalTasksDto addExternalTaskIdsItem(String externalTaskIdsItem) {
        if (this.externalTaskIds == null) {
            this.externalTaskIds = new ArrayList<String>();
        }
        this.externalTaskIds.add(externalTaskIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ids of the external tasks to set the number of retries for.")
    public List<String> getExternalTaskIds() {
        return this.externalTaskIds;
    }

    public void setExternalTaskIds(List<String> externalTaskIds) {
        this.externalTaskIds = externalTaskIds;
    }

    public SetRetriesForExternalTasksDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    public SetRetriesForExternalTasksDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.add(processInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ids of process instances containing the tasks to set the number of retries for.")
    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public SetRetriesForExternalTasksDto externalTaskQuery(ExternalTaskQueryDto externalTaskQuery) {
        this.externalTaskQuery = externalTaskQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExternalTaskQueryDto getExternalTaskQuery() {
        return this.externalTaskQuery;
    }

    public void setExternalTaskQuery(ExternalTaskQueryDto externalTaskQuery) {
        this.externalTaskQuery = externalTaskQuery;
    }

    public SetRetriesForExternalTasksDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public SetRetriesForExternalTasksDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetRetriesForExternalTasksDto setRetriesForExternalTasksDto = (SetRetriesForExternalTasksDto)o;
        return Objects.equals(this.retries, setRetriesForExternalTasksDto.retries) && Objects.equals(this.externalTaskIds, setRetriesForExternalTasksDto.externalTaskIds) && Objects.equals(this.processInstanceIds, setRetriesForExternalTasksDto.processInstanceIds) && Objects.equals(this.externalTaskQuery, setRetriesForExternalTasksDto.externalTaskQuery) && Objects.equals(this.processInstanceQuery, setRetriesForExternalTasksDto.processInstanceQuery) && Objects.equals(this.historicProcessInstanceQuery, setRetriesForExternalTasksDto.historicProcessInstanceQuery);
    }

    public int hashCode() {
        return Objects.hash(this.retries, this.externalTaskIds, this.processInstanceIds, this.externalTaskQuery, this.processInstanceQuery, this.historicProcessInstanceQuery);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetRetriesForExternalTasksDto {\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    externalTaskIds: ").append(this.toIndentedString(this.externalTaskIds)).append("\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    externalTaskQuery: ").append(this.toIndentedString(this.externalTaskQuery)).append("\n");
        sb.append("    processInstanceQuery: ").append(this.toIndentedString(this.processInstanceQuery)).append("\n");
        sb.append("    historicProcessInstanceQuery: ").append(this.toIndentedString(this.historicProcessInstanceQuery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

