/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ProcessInstanceModificationInstructionDto;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class StartProcessInstanceDto {
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_START_INSTRUCTIONS = "startInstructions";
    @SerializedName(value="startInstructions")
    private List<ProcessInstanceModificationInstructionDto> startInstructions = null;
    public static final String SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
    @SerializedName(value="skipCustomListeners")
    private Boolean skipCustomListeners;
    public static final String SERIALIZED_NAME_SKIP_IO_MAPPINGS = "skipIoMappings";
    @SerializedName(value="skipIoMappings")
    private Boolean skipIoMappings;
    public static final String SERIALIZED_NAME_WITH_VARIABLES_IN_RETURN = "withVariablesInReturn";
    @SerializedName(value="withVariablesInReturn")
    private Boolean withVariablesInReturn;

    public StartProcessInstanceDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The business key of the process instance.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public StartProcessInstanceDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public StartProcessInstanceDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public StartProcessInstanceDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The case instance id the process instance is to be initialized with.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public StartProcessInstanceDto startInstructions(List<ProcessInstanceModificationInstructionDto> startInstructions) {
        this.startInstructions = startInstructions;
        return this;
    }

    public StartProcessInstanceDto addStartInstructionsItem(ProcessInstanceModificationInstructionDto startInstructionsItem) {
        if (this.startInstructions == null) {
            this.startInstructions = new ArrayList<ProcessInstanceModificationInstructionDto>();
        }
        this.startInstructions.add(startInstructionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.")
    public List<ProcessInstanceModificationInstructionDto> getStartInstructions() {
        return this.startInstructions;
    }

    public void setStartInstructions(List<ProcessInstanceModificationInstructionDto> startInstructions) {
        this.startInstructions = startInstructions;
    }

    public StartProcessInstanceDto skipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip execution listener invocation for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the `startInstructions` property.")
    public Boolean getSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public void setSkipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }

    public StartProcessInstanceDto skipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.18/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the `startInstructions` property.")
    public Boolean getSkipIoMappings() {
        return this.skipIoMappings;
    }

    public void setSkipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
    }

    public StartProcessInstanceDto withVariablesInReturn(Boolean withVariablesInReturn) {
        this.withVariablesInReturn = withVariablesInReturn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the variables, which was used by the process instance during execution, should be returned. Default value: `false`")
    public Boolean getWithVariablesInReturn() {
        return this.withVariablesInReturn;
    }

    public void setWithVariablesInReturn(Boolean withVariablesInReturn) {
        this.withVariablesInReturn = withVariablesInReturn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartProcessInstanceDto startProcessInstanceDto = (StartProcessInstanceDto)o;
        return Objects.equals(this.businessKey, startProcessInstanceDto.businessKey) && Objects.equals(this.variables, startProcessInstanceDto.variables) && Objects.equals(this.caseInstanceId, startProcessInstanceDto.caseInstanceId) && Objects.equals(this.startInstructions, startProcessInstanceDto.startInstructions) && Objects.equals(this.skipCustomListeners, startProcessInstanceDto.skipCustomListeners) && Objects.equals(this.skipIoMappings, startProcessInstanceDto.skipIoMappings) && Objects.equals(this.withVariablesInReturn, startProcessInstanceDto.withVariablesInReturn);
    }

    public int hashCode() {
        return Objects.hash(this.businessKey, this.variables, this.caseInstanceId, this.startInstructions, this.skipCustomListeners, this.skipIoMappings, this.withVariablesInReturn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StartProcessInstanceDto {\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    startInstructions: ").append(this.toIndentedString(this.startInstructions)).append("\n");
        sb.append("    skipCustomListeners: ").append(this.toIndentedString(this.skipCustomListeners)).append("\n");
        sb.append("    skipIoMappings: ").append(this.toIndentedString(this.skipIoMappings)).append("\n");
        sb.append("    withVariablesInReturn: ").append(this.toIndentedString(this.withVariablesInReturn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

