/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TelemetryLicenseKeyDto {
    public static final String SERIALIZED_NAME_CUSTOMER = "customer";
    @SerializedName(value="customer")
    private String customer;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VALID_UNTIL = "valid-until";
    @SerializedName(value="valid-until")
    private Date validUntil;
    public static final String SERIALIZED_NAME_UNLIMITED = "unlimited";
    @SerializedName(value="unlimited")
    private Boolean unlimited;
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private Map<String, String> features = null;
    public static final String SERIALIZED_NAME_RAW = "raw";
    @SerializedName(value="raw")
    private String raw;

    public TelemetryLicenseKeyDto customer(String customer) {
        this.customer = customer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the customer the license was issued for.")
    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public TelemetryLicenseKeyDto type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The license type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TelemetryLicenseKeyDto validUntil(Date validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The expiration date of the license.")
    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public TelemetryLicenseKeyDto unlimited(Boolean unlimited) {
        this.unlimited = unlimited;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag that indicates if the license is unlimited.")
    public Boolean getUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(Boolean unlimited) {
        this.unlimited = unlimited;
    }

    public TelemetryLicenseKeyDto features(Map<String, String> features) {
        this.features = features;
        return this;
    }

    public TelemetryLicenseKeyDto putFeaturesItem(String key, String featuresItem) {
        if (this.features == null) {
            this.features = new HashMap<String, String>();
        }
        this.features.put(key, featuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A map of features included in the license.")
    public Map<String, String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, String> features) {
        this.features = features;
    }

    public TelemetryLicenseKeyDto raw(String raw) {
        this.raw = raw;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The raw license information.")
    public String getRaw() {
        return this.raw;
    }

    public void setRaw(String raw) {
        this.raw = raw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryLicenseKeyDto telemetryLicenseKeyDto = (TelemetryLicenseKeyDto)o;
        return Objects.equals(this.customer, telemetryLicenseKeyDto.customer) && Objects.equals(this.type, telemetryLicenseKeyDto.type) && Objects.equals(this.validUntil, telemetryLicenseKeyDto.validUntil) && Objects.equals(this.unlimited, telemetryLicenseKeyDto.unlimited) && Objects.equals(this.features, telemetryLicenseKeyDto.features) && Objects.equals(this.raw, telemetryLicenseKeyDto.raw);
    }

    public int hashCode() {
        return Objects.hash(this.customer, this.type, this.validUntil, this.unlimited, this.features, this.raw);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelemetryLicenseKeyDto {\n");
        sb.append("    customer: ").append(this.toIndentedString(this.customer)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    validUntil: ").append(this.toIndentedString(this.validUntil)).append("\n");
        sb.append("    unlimited: ").append(this.toIndentedString(this.unlimited)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    raw: ").append(this.toIndentedString(this.raw)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

