/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TriggerVariableValueDto {
    public static final String SERIALIZED_NAME_LOCAL = "local";
    @SerializedName(value="local")
    private Boolean local;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private Object value = null;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VALUE_INFO = "valueInfo";
    @SerializedName(value="valueInfo")
    private Map<String, Object> valueInfo = null;

    public TriggerVariableValueDto local(Boolean local) {
        this.local = local;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the variable should be a local variable or not. If set to true, the variable becomes a local variable of the execution entering the target activity.")
    public Boolean getLocal() {
        return this.local;
    }

    public void setLocal(Boolean local) {
        this.local = local;
    }

    public TriggerVariableValueDto value(Object value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be any value - string, number, boolean, array or object.  **Note**: Not every endpoint supports every type.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public TriggerVariableValueDto type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The value type of the variable.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TriggerVariableValueDto valueInfo(Map<String, Object> valueInfo) {
        this.valueInfo = valueInfo;
        return this;
    }

    public TriggerVariableValueDto putValueInfoItem(String key, Object valueInfoItem) {
        if (this.valueInfo == null) {
            this.valueInfo = new HashMap<String, Object>();
        }
        this.valueInfo.put(key, valueInfoItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing additional, value-type-dependent properties. For serialized variables of type Object, the following properties can be provided:  * `objectTypeName`: A string representation of the object's type name. * `serializationDataFormat`: The serialization format used to store the variable.  For serialized variables of type File, the following properties can be provided:  * `filename`: The name of the file. This is not the variable name but the name that will be used when downloading the file again. * `mimetype`: The MIME type of the file that is being uploaded. * `encoding`: The encoding of the file that is being uploaded.  The following property can be provided for all value types:  * `transient`: Indicates whether the variable should be transient or not. See [documentation](https://docs.camunda.org/manual/7.18/user-guide/process-engine/variables#transient-variables) for more informations. (Not applicable for `decision-definition`, ` /process-instance/variables-async`, and `/migration/executeAsync` endpoints)")
    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }

    public void setValueInfo(Map<String, Object> valueInfo) {
        this.valueInfo = valueInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerVariableValueDto triggerVariableValueDto = (TriggerVariableValueDto)o;
        return Objects.equals(this.local, triggerVariableValueDto.local) && Objects.equals(this.value, triggerVariableValueDto.value) && Objects.equals(this.type, triggerVariableValueDto.type) && Objects.equals(this.valueInfo, triggerVariableValueDto.valueInfo);
    }

    public int hashCode() {
        return Objects.hash(this.local, this.value, this.type, this.valueInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TriggerVariableValueDto {\n");
        sb.append("    local: ").append(this.toIndentedString(this.local)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    valueInfo: ").append(this.toIndentedString(this.valueInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

